/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.utils.HardLinkHelper;
import org.sonatype.nexus.repository.docker.UploadManager;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerV1Utility;
import org.sonatype.nexus.repository.docker.internal.Upload;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.docker.internal.UploadManagerImpl;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.V2TagListResult;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerAssetSearch;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerHostedFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Named
public class DockerHostedFacetImpl
extends DockerHostedFacetSupport {
    private DockerContentFacet dockerContentFacet;
    private final V2ManifestUtil v2ManifestUtil;
    private final DockerAssetSearch dockerAssetSearch;
    private final HashAlgorithmHelper hashAlgorithmHelper;
    private final HardLinkHelper hardLinkHelper;

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.dockerContentFacet = (DockerContentFacet)this.facet(DockerContentFacet.class);
    }

    @Inject
    public DockerHostedFacetImpl(V2ManifestUtil v2ManifestUtil, DockerAssetSearch dockerAssetSearch, HashAlgorithmHelper hashAlgorithmHelper, HardLinkHelper hardLinkHelper, @Named(value="${nexus.docker.upload.lock.size:-64}") int uploadLockSize) {
        super(uploadLockSize);
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.dockerAssetSearch = (DockerAssetSearch)((Object)Preconditions.checkNotNull((Object)((Object)dockerAssetSearch)));
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
        this.hardLinkHelper = (HardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
    }

    @Override
    protected UploadManager createUploadManager(int uploadLockSize) {
        return new UploadManagerImpl((Provider<BlobStore>)((Provider)() -> ((ContentFacetSupport)this.facet(DockerContentFacet.class)).stores().blobStore), uploadLockSize);
    }

    @Override
    public Content getImagesIndex(String name) {
        Content imagesIndexContent = this.dockerContentFacet.get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1imagesIndexName(name))).orElse(null);
        if (imagesIndexContent == null) {
            throw new V1Exception.ImagesNotFound();
        }
        return imagesIndexContent;
    }

    @Override
    public void putImagesIndex(String name, Payload content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)new Content(content), DockerFacetUtils.HASH_ALGORITHMS);){
            DockerFacetUtils.readImagesIndex((InputStreamSupplier)tempBlob);
            this.doPutImagesIndex(name, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doPutImagesIndex(String name, TempBlob imagesIndexContent, Payload payload) throws IOException {
        String imagesIndexPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1imagesIndexName(name));
        Content existingImagesIndexContent = this.dockerContentFacet.get(imagesIndexPath).orElse(null);
        if (existingImagesIndexContent == null) {
            this.dockerContentFacet.putHardLinkedBlob(imagesIndexPath, imagesIndexContent, (Payload)new Content(payload), AssetKind.IMAGES, new HashMap<String, Object>());
        } else {
            List<Map<String, Object>> mergedIndex = DockerV1Utility.mergeIndexes(DockerFacetUtils.readImagesIndex(() -> ((Content)existingImagesIndexContent).openInputStream()), DockerFacetUtils.readImagesIndex((InputStreamSupplier)imagesIndexContent));
            byte[] buf = DockerFacetUtils.mapper.writeValueAsBytes(mergedIndex);
            this.dockerContentFacet.putHardLinkedBlob(imagesIndexPath, (Payload)new Content((Payload)new BytesPayload(buf, "application/json")), AssetKind.IMAGES, new HashMap<String, Object>());
        }
    }

    @Override
    public Content getLayerMetadata(String layerId) throws IOException {
        FluentAsset layerMetadataAsset = this.findMetadataAsset(layerId);
        Content content = layerMetadataAsset.download();
        NestedAttributesMap formatAttributes = layerMetadataAsset.attributes("docker");
        content.getAttributes().set("X-Docker-Size", formatAttributes.get("X-Docker-Size"));
        content.getAttributes().set("X-Docker-Checksum-Payload", formatAttributes.get("X-Docker-Checksum-Payload"));
        content.getAttributes().set("Docker-Content-Digest", layerMetadataAsset.attributes().child("docker").get("content_digest"));
        layerMetadataAsset.markAsDownloaded();
        return content;
    }

    @Override
    public void putLayerMetadata(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)new Content(content), DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutLayerMetadata(layerId, tempBlob, content, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doPutLayerMetadata(String layerId, TempBlob layerMetadataContent, Payload payload, boolean verifyParentLevel) throws IOException {
        Map<String, Object> layerMetadata = DockerFacetUtils.readLayerMetadata((InputStreamSupplier)layerMetadataContent);
        this.verifyLayerMetadata(layerId, layerMetadata);
        String parentId = (String)layerMetadata.get("parent");
        List ancestry = null;
        AttributesMap parentFormatAttributes = new AttributesMap();
        if (parentId != null) {
            Optional<FluentAsset> asset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(parentId)));
            if (asset.isPresent()) {
                parentFormatAttributes = asset.get().attributes().child("docker");
                ancestry = (List)parentFormatAttributes.get("ancestry", DockerAttributes.T_ANCESTRY);
            }
            if (verifyParentLevel && !asset.isPresent() || Boolean.TRUE.equals(parentFormatAttributes.get("inProgress"))) {
                throw new V1Exception.InvalidLayerMetadata("Image depends on a non existing parent");
            }
        }
        if (ancestry == null) {
            ancestry = Lists.newArrayList();
        }
        ancestry.add(0, layerId);
        String metadataAssetPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId));
        Optional<FluentAsset> metadataAsset = this.dockerContentFacet.findAsset(metadataAssetPath);
        AttributesMap formatAttributes = metadataAsset.isPresent() ? metadataAsset.get().attributes().child("docker") : new AttributesMap();
        formatAttributes.set("parent", (Object)parentId);
        formatAttributes.set("ancestry", (Object)ancestry);
        formatAttributes.set("arch", layerMetadata.get("os"));
        formatAttributes.set("os", layerMetadata.get("architecture"));
        if (metadataAsset.isPresent()) {
            if (!Boolean.TRUE.equals(formatAttributes.get("inProgress"))) {
                throw new V1Exception.ImageAlreadyExists();
            }
            formatAttributes.remove("X-Docker-Checksum-Payload");
            metadataAsset.get().withAttribute("docker", (Object)formatAttributes);
        } else {
            formatAttributes.set("layerId", (Object)layerId);
            formatAttributes.set("inProgress", (Object)true);
            this.dockerContentFacet.putHardLinkedBlob(metadataAssetPath, layerMetadataContent, (Payload)new Content(payload), AssetKind.LAYER_METADATA, formatAttributes.backing());
        }
    }

    private void verifyLayerMetadata(String layerId, Map<String, Object> layerMetadata) {
        if (!layerMetadata.containsKey("id")) {
            throw new V1Exception.InvalidLayerMetadata("Missing key 'id' in JSON");
        }
        if (!layerMetadata.get("id").equals(layerId)) {
            throw new V1Exception.InvalidLayerMetadata("JSON data contains invalid id");
        }
    }

    @Override
    public Content getLayerContent(String layerId) {
        DockerFacetUtils.validateLayerId(layerId);
        this.findMetadataAsset(layerId);
        Content layerContentAsset = this.dockerContentFacet.get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerContentName(layerId))).orElse(null);
        if (layerContentAsset == null) {
            throw new V1Exception.ImageNotFound();
        }
        return layerContentAsset;
    }

    @Override
    public void putLayerContent(String layerId, Payload content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)new Content(content), DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutLayerContent(layerId, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putLayerContent(String layerId, Payload payload, File content) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(content, DockerFacetUtils.HASH_ALGORITHMS);
        Blob blob = this.hardLinkHelper.ingestHardLink(this.getRepository(), content, (HashCode)checksums.get(HashAlgorithm.SHA1));
        this.doPutLayerContent(layerId, blob, checksums, payload);
    }

    protected void doPutLayerContent(String layerId, TempBlob layerContent, Payload payload) throws IOException {
        FluentAsset asset = this.findAsset(layerId);
        Content content = new Content(payload);
        String layerContentPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerContentName(layerId));
        HashMap<String, Object> layerAttrs = new HashMap<String, Object>();
        layerAttrs.put("layerId", layerId);
        Content layerAsset = this.dockerContentFacet.putHardLinkedBlob(layerContentPath, layerContent, (Payload)content, AssetKind.LAYER_CONTENT, layerAttrs);
        String checksum = DockerFacetDatabaseUtils.calculateChecksum(asset.download(), layerAsset).toString();
        this.fillLayerMetadataAttributes(layerId, asset, content, checksum);
    }

    protected void doPutLayerContent(String layerId, Blob layerContent, Map<HashAlgorithm, HashCode> checksums, Payload payload) {
        FluentAsset asset = this.findAsset(layerId);
        String layerContentPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerContentName(layerId));
        Content content = new Content(payload);
        this.dockerContentFacet.putHardLinkedBlob(layerContentPath, layerContent, checksums, (Payload)content, AssetKind.LAYER_CONTENT);
        String checksum = checksums.get(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM).toString();
        this.fillLayerMetadataAttributes(layerId, asset, content, checksum);
    }

    @Override
    public void doPutLayerChecksum(String layerId, String checksum) {
        Optional<FluentAsset> metadataAsset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId)));
        if (!metadataAsset.isPresent()) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap formatAttributes = metadataAsset.get().attributes().child("docker");
        if (!Boolean.TRUE.equals(formatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists("Cannot set this image checksum");
        }
        Object actualChecksum = formatAttributes.get("X-Docker-Checksum-Payload");
        if (!checksum.equals(actualChecksum)) {
            this.log.error("Wrong checksum. Actual: {}; Expected: {}", actualChecksum, (Object)checksum);
            throw new V1Exception.InvalidChecksum("Checksum mismatch");
        }
        formatAttributes.remove("inProgress");
        metadataAsset.get().withAttribute("docker", (Object)formatAttributes.backing());
    }

    @Override
    public Content getLayerAncestry(String layerId) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        Optional<FluentAsset> metaDataAsset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId)));
        if (!metaDataAsset.isPresent()) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap formatAttributes = metaDataAsset.get().attributes().child("docker");
        String where = String.format("%s IS NOT NULL AND %s LIKE #{filterParams.layerId}", "component_id", "attributes::text");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("layerId", "%docker%layerId%" + layerId + "%");
        Iterable<FluentAsset> assets = this.dockerContentFacet.findAssets(where, parameters);
        for (FluentAsset asset : assets) {
            asset.markAsDownloaded();
        }
        String ancestry = DockerFacetUtils.mapper.writeValueAsString(formatAttributes.get("ancestry"));
        return new Content((Payload)new StringPayload(ancestry, "application/json"));
    }

    @Override
    public Content getTags(String name) throws IOException {
        Iterable<FluentComponent> tagComponents = this.dockerContentFacet.findComponentsByName(name);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (FluentComponent tagComponent : tagComponents) {
            tags.put(tagComponent.version(), tagComponent.attributes("docker").get("layerId").toString());
        }
        if (tags.isEmpty()) {
            throw new V1Exception.RepositoryNotFound();
        }
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString(tags), "application/json"));
    }

    @Override
    public Content getTag(String name, String tag) throws IOException {
        Optional<FluentComponent> tagComponent = this.dockerContentFacet.findComponentByNameAndTag(name, tag);
        if (!tagComponent.isPresent()) {
            throw new V1Exception.TagNotFound();
        }
        String tagAssetName = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1tagName(name, tag));
        Content tagAsseContent = this.dockerContentFacet.get(tagAssetName).orElse(null);
        if (tagAsseContent == null) {
            throw new V1Exception.TagNotFound();
        }
        String layerId = tagComponent.get().attributes().child("docker").get("layerId").toString();
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)layerId), "application/json"));
    }

    @Override
    public void putTag(String name, String tag, @Nullable Map<String, String> daemonMetadata, Payload content) throws IOException {
        DockerFacetUtils.validateTagName(tag);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest(content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutTag(name, tag, daemonMetadata, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doPutTag(String name, String tag, @Nullable Map<String, String> daemonMetadata, TempBlob tagContent, Payload payload) throws IOException {
        this.getImagesIndex(name);
        String layerId = DockerFacetUtils.readLayerId((InputStreamSupplier)tagContent);
        FluentAsset metadataAsset = this.findMetadataAsset(layerId);
        Optional<FluentComponent> existingTagComponent = this.dockerContentFacet.findComponentByNameAndTag(name, tag);
        Map<String, String> componentAttributes = existingTagComponent.isPresent() ? existingTagComponent.get().attributes().child("docker").backing() : new HashMap<String, String>();
        componentAttributes.put("layerId", layerId);
        componentAttributes.put("layerAncestry", (String)metadataAsset.attributes().child("docker").get("ancestry"));
        if (daemonMetadata != null) {
            componentAttributes.put("daemonMetadata", (String)((Object)daemonMetadata));
        }
        HashMap<String, Object> assetAttributes = new HashMap<String, Object>();
        assetAttributes.put("layerId", layerId);
        this.dockerContentFacet.putTag(name, tag, (Payload)new TempBlobPayload(tagContent, payload.getContentType()), assetAttributes, componentAttributes);
    }

    @Override
    public Content getBlob(DockerDigest digest) {
        String blobName = DockerFacetUtils.blobName(digest);
        Content blobContent = this.dockerContentFacet.get(DockerFacetDatabaseUtils.assetPath(blobName)).orElse(null);
        if (blobContent == null) {
            throw new V2Exception.BlobNotFound(digest);
        }
        return blobContent;
    }

    @Override
    public void deleteBlob(DockerDigest digest) {
        String blobName = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(digest));
        Optional<FluentAsset> asset = this.dockerContentFacet.findAsset(blobName);
        if (!asset.isPresent()) {
            throw new V2Exception.BlobNotFound(digest);
        }
        asset.get().delete();
    }

    @Override
    protected UploadCompletion createUploadCompletion(String name, DockerDigest digest, Content content, Upload upload) {
        String location = String.valueOf(BaseUrlHolder.get()) + "/v2/" + name + "/blobs/" + digest;
        return new UploadCompletion(content, location, digest.toString(), "0-" + (upload.length() - 1L));
    }

    @Override
    protected Content saveUploadToAsset(Upload upload, DockerDigest digest) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Optional<FluentAsset> asset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(digest)));
        if (!asset.isPresent()) {
            Content content = new Content((Payload)new StreamPayload(upload::getInputStream, upload.length(), "application/gzip"));
            return this.dockerContentFacet.putBlob(digest, (Payload)content, AssetKind.BLOB, attributes);
        }
        return this.getContent(upload, digest, asset.get());
    }

    @Override
    protected Content saveUploadToAssetViaHardLink(File blobLocation, Upload upload, DockerDigest digest) throws IOException {
        Optional<FluentAsset> asset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(digest)));
        if (!asset.isPresent()) {
            Content content = new Content((Payload)new StreamPayload(upload::getInputStream, upload.length(), "application/gzip"));
            return this.dockerContentFacet.putHardLinkedBlob(blobLocation, digest, (Payload)content, AssetKind.BLOB);
        }
        return this.getContent(upload, digest, asset.get());
    }

    @Override
    public Content getTagList(String name) throws IOException {
        Iterable<FluentComponent> components = this.dockerContentFacet.findComponentsByName(name);
        if (!components.iterator().hasNext()) {
            throw new V2Exception.NameUnknown(name);
        }
        V2TagListResult tagList = new V2TagListResult();
        tagList.setName(name);
        for (FluentComponent component : components) {
            tagList.getTags().add(component.version());
        }
        tagList.getTags().sort(null);
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)tagList), "application/json"));
    }

    @Override
    public Content putManifestByTag(String name, String tag, Payload payload, boolean verifyManifest) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest(payload, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByTag(name, tag, tempBlob, payload.getContentType(), new Content(payload), verifyManifest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Content doPutManifestByTag(String name, String tag, TempBlob manifestContent, @Nullable String manifestContentType, Content content, boolean verifyManifest) throws IOException {
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent);
        Content digestContent = this.doPutManifestByDigest(name, tag, manifestDigest, manifestContent, manifestContentType, content, verifyManifest);
        return this.dockerContentFacet.putManifestByTag(name, tag, manifestDigest, (Payload)digestContent);
    }

    @Override
    public Content putManifestByDigest(String name, DockerDigest digest, Payload payload, boolean verifyManifest) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)new Content(payload), DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, null, digest, tempBlob, payload.getContentType(), new Content(payload), verifyManifest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Content doPutManifestByDigest(String name, @Nullable String tag, DockerDigest digest, TempBlob manifestContent, @Nullable String manifestContentType, Content content, boolean verifyManifest) throws IOException {
        DockerDigest manifestDigest;
        V2Manifest manifest = this.v2ManifestUtil.readManifest((InputStreamSupplier)manifestContent, name, manifestContentType);
        if (verifyManifest) {
            this.v2ManifestUtil.validateManifest(this.getRepository(), name, tag, manifest);
        }
        if (!(manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent)).equals(digest)) {
            throw new V2Exception.DigestInvalid("digest mismatch");
        }
        return this.dockerContentFacet.putManifestByDigest(name, manifestDigest, (Payload)new Content(content, (Payload)new TempBlobPayload(manifestContent, manifestContentType)));
    }

    @Override
    protected Iterable<String> getUniqueComponentNames() {
        HashSet<String> uniqueComponentsNames = new HashSet<String>();
        Collection componentsNames = this.dockerContentFacet.components().names("");
        for (String componentName : componentsNames) {
            uniqueComponentsNames.add(componentName);
        }
        return uniqueComponentsNames;
    }

    @Override
    public Content getManifestByTag(String name, String tag, V2Manifest.SchemaVersion schemaVersion) throws IOException {
        Content manifestAsset = this.dockerContentFacet.get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.tagName(name, tag))).orElse(null);
        if (manifestAsset == null) {
            throw new V2Exception.ManifestUnknownByTag(name, tag);
        }
        Content content = this.v2ManifestUtil.mayDowngrade(manifestAsset, name, tag, schemaVersion, this.getRepository());
        return DockerFacetUtils.createDockerManifestContent(content, content.getContentType());
    }

    @Override
    public Content getManifestByDigest(String name, DockerDigest digest) {
        Content manifestAsset = this.dockerContentFacet.get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.manifestName(name, digest))).orElse(null);
        if (manifestAsset == null) {
            Set<String> manifestsNames = this.dockerAssetSearch.findByContentDigest(digest, this.getRepository().getName());
            if (!manifestsNames.isEmpty()) {
                manifestAsset = this.dockerContentFacet.get(manifestsNames.iterator().next()).orElse(null);
            }
            if (manifestAsset == null) {
                throw new V2Exception.ManifestUnknownByDigest(name, digest);
            }
        }
        return DockerFacetUtils.createDockerManifestContent(manifestAsset, manifestAsset.getContentType());
    }

    @Override
    public void deleteManifest(String name, DockerDigest digest) throws IOException {
        boolean changed = false;
        if (this.maybeDeleteByContentDigest(digest, name)) {
            changed = true;
        }
        if (this.maybeDeleteByTag(digest)) {
            changed = true;
        }
        if (!changed) {
            throw new V2Exception.ManifestUnknownByDigest(name, digest);
        }
    }

    private boolean maybeDeleteByTag(DockerDigest digest) {
        boolean isDeleted = false;
        Set<String> manifestsPaths = this.dockerAssetSearch.findByContentDigest(digest, this.getRepository().getName());
        if (!manifestsPaths.isEmpty()) {
            for (String manifestPath : manifestsPaths) {
                Component tagComponent;
                Optional<FluentComponent> component;
                FluentAsset manifestAsset;
                Optional assetComponent;
                Optional<FluentAsset> manifest = this.dockerContentFacet.findAsset(manifestPath);
                if (!manifest.isPresent() || !(assetComponent = (manifestAsset = manifest.get()).component()).isPresent() || !(component = this.dockerContentFacet.findComponentByNameAndTag((tagComponent = (Component)assetComponent.get()).name(), tagComponent.version())).isPresent()) continue;
                manifestAsset.delete();
                component.get().delete();
                isDeleted = true;
            }
        }
        return isDeleted;
    }

    private boolean maybeDeleteByContentDigest(DockerDigest digest, String name) {
        Optional<FluentAsset> manifestAsset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.manifestName(name, digest)));
        if (manifestAsset.isPresent()) {
            manifestAsset.get().delete();
            return true;
        }
        return false;
    }

    private FluentAsset findMetadataAsset(String layerId) {
        Optional<FluentAsset> metadataAsset = this.dockerContentFacet.findAsset(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId)));
        if (!metadataAsset.isPresent()) {
            throw new V1Exception.ImageNotFound();
        }
        NestedAttributesMap formatAttributes = metadataAsset.get().attributes().child("docker");
        if (Boolean.TRUE.equals(formatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageNotFound();
        }
        return metadataAsset.get();
    }

    @Override
    public Content importManifestByDigest(String name, DockerDigest digest, Payload payload) throws IOException {
        return this.putManifestByDigest(name, digest, payload, false);
    }

    @Override
    public Content importManifestByTag(String name, String tag, Payload payload) throws IOException {
        Content content = new Content(payload);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)new Content(payload), DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByTag(name, tag, tempBlob, payload.getContentType(), content, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content importV1LayerMetadata(String layerId, Payload payload) throws IOException {
        DockerFacetUtils.validateLayerId(layerId);
        Content content = new Content(payload);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.dockerContentFacet.blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.doPutLayerMetadata(layerId, tempBlob, (Payload)content, false);
            return content;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content importV1LayerContent(String layerId, Payload payload) throws IOException {
        this.putLayerContent(layerId, payload);
        return this.getContent(layerId, payload);
    }

    @Override
    public Content importV1LayerContent(String layerId, Payload payload, File content) throws IOException {
        this.putLayerContent(layerId, payload, content);
        return this.getContent(layerId, payload);
    }

    @Override
    public Content importV1ImagesIndex(String name, Payload content) throws IOException {
        this.putImagesIndex(name, content);
        return new Content(content);
    }

    @Override
    public Content importV1Tag(String name, String tag, Payload content) throws IOException {
        this.putTag(name, tag, null, content);
        return new Content(content);
    }

    private void fillLayerMetadataAttributes(String layerId, FluentAsset asset, Content content, String checksum) {
        NestedAttributesMap layerMetadataFormatAttributes = asset.attributes().child("docker");
        if (!Boolean.TRUE.equals(layerMetadataFormatAttributes.get("inProgress"))) {
            throw new V1Exception.ImageAlreadyExists();
        }
        layerMetadataFormatAttributes.set("layerId", (Object)layerId);
        layerMetadataFormatAttributes.set("X-Docker-Size", (Object)content.getSize());
        layerMetadataFormatAttributes.set("X-Docker-Checksum-Payload", (Object)checksum);
        asset.withAttribute("docker", (Object)layerMetadataFormatAttributes.backing());
    }

    private FluentAsset findAsset(String layerId) {
        String layerMetadataPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId));
        return this.dockerContentFacet.findAsset(layerMetadataPath).orElseThrow(V1Exception.ImageNotFound::new);
    }

    private Content getContent(String layerId, Payload payload) {
        String metadataAssetPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId));
        Optional<FluentAsset> metadata = this.dockerContentFacet.findAsset(metadataAssetPath);
        if (metadata.isPresent()) {
            FluentAsset metadataAsset = metadata.get();
            NestedAttributesMap formatAttributes = metadataAsset.attributes().child("docker");
            formatAttributes.remove("inProgress");
            metadataAsset.withAttribute("docker", (Object)formatAttributes.backing());
        }
        return new Content(payload);
    }

    private Content getContent(Upload upload, DockerDigest digest, FluentAsset asset) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream inputStream = upload.getInputStream();){
            DockerFacetUtils.validateContentDigest(inputStream, digest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.log.debug("Digest {} already exists, discarding.", (Object)digest);
        this.log.debug("UUID ALREADY exists {}", (Object)upload.getUuid());
        return asset.download();
    }
}

