/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.docker.DockerGCFacet;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.docker.internal.MediaType;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.scheduling.CancelableHelper;

public class DockerGCFacetImpl
extends FacetSupport
implements DockerGCFacet {
    private static final String KIND = "kind";
    private static final String LAST_UPDATED = "last_updated";
    private final V2ManifestUtil v2ManifestUtil;
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public DockerGCFacetImpl(V2ManifestUtil v2ManifestUtil, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteUnusedManifestsAndImages(int deployOffsetHours) {
        Repository repository = this.getRepository();
        this.log.info("Garbage collection starting on repository: {}", (Object)repository);
        boolean isStorageAvailable = false;
        try {
            String blobStoreName = (String)((Map)Objects.requireNonNull(repository.getConfiguration().getAttributes()).get("storage")).get("blobStoreName");
            isStorageAvailable = Objects.requireNonNull(this.blobStoreManager.get(blobStoreName)).isStorageAvailable();
        }
        catch (NullPointerException nullPointerException) {}
        if (!isStorageAvailable) {
            this.log.error("Garbage collection skipped for repository: {} (its Blob Store is unavailable)", (Object)repository);
            return;
        }
        try {
            this.processRepository(repository, deployOffsetHours);
            this.log.info("Garbage collection completed on repository: {}", (Object)repository);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processRepository(Repository repository, int deployOffsetHours) throws IOException {
        OffsetDateTime offsetTime = OffsetDateTime.now().minusHours(deployOffsetHours);
        this.handleV1Assets(repository, offsetTime);
        this.handleV2Assets(repository, offsetTime);
    }

    @VisibleForTesting
    void handleV1Assets(Repository repository, OffsetDateTime offsetTime) throws IOException {
        CancelableHelper.checkCancellation();
        DockerContentFacet dockerContentFacet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        Continuation<FluentComponent> components = dockerContentFacet.getV1ComponentsBeforeOffset(offsetTime, null);
        while (!components.isEmpty()) {
            HashSet usedLayerIds = new HashSet();
            for (FluentComponent component : components) {
                String layerId;
                CancelableHelper.checkCancellation();
                List layerAncestry = (List)component.attributes().child("docker").get("layerAncestry");
                if (layerAncestry == null && (layerId = (String)component.attributes("docker").get("layerId")) != null) {
                    DockerHostedFacet dockerHostedFacet = (DockerHostedFacet)repository.facet(DockerHostedFacet.class);
                    layerAncestry = (List)dockerHostedFacet.getLayerAncestry(layerId);
                }
                if (layerAncestry == null) continue;
                usedLayerIds.addAll(layerAncestry);
            }
            CancelableHelper.checkCancellation();
            String where = String.format("(%s = '%s' OR %s = '%s') AND %s < '%s'", KIND, AssetKind.LAYER_CONTENT.name(), KIND, AssetKind.LAYER_METADATA.name(), LAST_UPDATED, offsetTime.toString());
            Continuation<FluentAsset> assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), null);
            while (!assets.isEmpty()) {
                for (FluentAsset asset : assets) {
                    CancelableHelper.checkCancellation();
                    if (usedLayerIds.contains(asset.attributes("docker").get("layerId").toString())) continue;
                    this.log.debug("Found layer to delete {}", (Object)asset);
                    asset.delete();
                }
                assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), assets.nextContinuationToken());
            }
            components = dockerContentFacet.getV1ComponentsBeforeOffset(offsetTime, components.nextContinuationToken());
        }
    }

    @VisibleForTesting
    void handleV2Assets(Repository repository, OffsetDateTime offsetTime) {
        CancelableHelper.checkCancellation();
        DockerContentFacet dockerContentFacet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        HashSet<String> taggedManifestDigests = new HashSet<String>();
        HashSet<FluentAsset> digestManifests = new HashSet<FluentAsset>();
        HashSet<String> usedLayerDigests = new HashSet<String>();
        this.fetchDataForRepository(repository, usedLayerDigests, taggedManifestDigests, digestManifests);
        this.deleteDigestManifests(offsetTime, taggedManifestDigests, digestManifests);
        CancelableHelper.checkCancellation();
        List<FluentAsset> unusedAssets = this.findUnusedAssets(offsetTime, dockerContentFacet, usedLayerDigests);
        this.checkForReferencesInOtherRepositories(repository, unusedAssets);
        this.log.debug("Deleting {} assets", (Object)unusedAssets.size());
        unusedAssets.forEach(FluentAsset::delete);
    }

    private void deleteDigestManifests(OffsetDateTime offsetTime, Set<String> taggedManifestDigests, Set<FluentAsset> digestManifests) {
        for (FluentAsset asset : digestManifests) {
            CancelableHelper.checkCancellation();
            if (!asset.lastUpdated().isBefore(offsetTime) || taggedManifestDigests.contains(asset.attributes("docker").get("content_digest").toString())) continue;
            this.log.debug("Found manifest to delete {}", (Object)asset);
            asset.delete();
        }
    }

    private List<FluentAsset> findUnusedAssets(OffsetDateTime offsetTime, DockerContentFacet dockerContentFacet, Set<String> usedLayerDigests) {
        ArrayList<FluentAsset> unusedAssets = new ArrayList<FluentAsset>();
        String where = String.format("%s = '%s' AND %s < '%s'", KIND, AssetKind.BLOB.name(), LAST_UPDATED, offsetTime.toString());
        Continuation<FluentAsset> assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), null);
        while (!assets.isEmpty()) {
            for (FluentAsset asset : assets) {
                CancelableHelper.checkCancellation();
                if (usedLayerDigests.contains(asset.attributes("docker").get("content_digest").toString())) continue;
                this.log.debug("Found possible asset to delete {}", (Object)asset);
                unusedAssets.add(asset);
            }
            assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), assets.nextContinuationToken());
        }
        return unusedAssets;
    }

    private void fetchDataForRepository(Repository repository, Set<String> usedLayerDigests, Set<String> taggedManifestDigests, Set<FluentAsset> digestManifests) {
        DockerContentFacet dockerContentFacet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        String where = String.format("%s = '%s'", KIND, AssetKind.MANIFEST.name());
        Continuation<FluentAsset> assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), null);
        while (!assets.isEmpty()) {
            for (FluentAsset asset : assets) {
                CancelableHelper.checkCancellation();
                if (digestManifests != null && this.isDigestManifest(asset.path())) {
                    digestManifests.add(asset);
                    continue;
                }
                if (taggedManifestDigests != null) {
                    taggedManifestDigests.add(asset.attributes("docker").get("content_digest").toString());
                }
                this.fetchDataForManifest(usedLayerDigests, taggedManifestDigests, asset);
            }
            assets = dockerContentFacet.findAssets(where, new HashMap<String, Object>(), assets.nextContinuationToken());
        }
    }

    private void fetchDataForManifest(Set<String> usedLayerDigests, Set<String> taggedManifestDigests, FluentAsset asset) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Content content = asset.download();){
                V2Manifest manifest = this.v2ManifestUtil.readManifest(() -> ((Content)content).openInputStream(), asset.path(), asset.kind());
                if (MediaType.IMAGE_INDEX.matches(this.getMediaType(manifest))) {
                    this.handleManifestList(asset, manifest, usedLayerDigests, taggedManifestDigests);
                }
                for (DockerDigest dockerDigest : manifest.referencedDigests()) {
                    usedLayerDigests.add(dockerDigest.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | V2Exception.ManifestInvalid e) {
            this.log.warn("Unable to read V2 Manifest for asset {}, {}", new Object[]{asset, e.getMessage(), this.log.isDebugEnabled() ? e : null});
        }
    }

    private void checkForReferencesInOtherRepositories(Repository repository, List<FluentAsset> unusedAssets) {
        HashSet<String> usedLayerDigests = new HashSet<String>();
        List repositories = Streams.stream((Iterable)this.repositoryManager.browse()).filter(DockerGCFacetImpl::isDockerRepository).collect(Collectors.toList());
        for (Repository repo : repositories) {
            if (repo.getName().equals(repository.getName()) || repo.getType().getValue().equals("group")) continue;
            this.log.debug("Checking {} for references to {}", (Object)repo.getName(), (Object)repository.getName());
            usedLayerDigests.clear();
            this.fetchDataForRepository(repo, usedLayerDigests, null, null);
            ListIterator<FluentAsset> it = unusedAssets.listIterator();
            while (it.hasNext()) {
                CancelableHelper.checkCancellation();
                FluentAsset asset = it.next();
                if (!usedLayerDigests.contains(asset.attributes("docker").get("content_digest").toString())) continue;
                this.log.debug("Found asset referenced in another repository {}", (Object)asset);
                it.remove();
            }
        }
    }

    private static boolean isDockerRepository(Repository repository) {
        return repository.getFormat().getValue().equals("docker");
    }

    private String getMediaType(V2Manifest manifest) {
        Object mediaType = manifest.getManifest().get("mediaType");
        return mediaType != null ? mediaType.toString() : null;
    }

    private boolean isDigestManifest(String name) {
        return name.contains("manifests/sha256:");
    }

    private void handleManifestList(FluentAsset asset, V2Manifest manifest, Set<String> usedLayerDigests, Set<String> taggedManifestDigests) {
        List<DockerDigest> listedManifests = manifest.getListedManifests();
        for (DockerDigest listedManifest : listedManifests) {
            String listedManifestName = this.getListedManifestName(asset, listedManifest);
            DockerContentFacet dockerContentFacet = (DockerContentFacet)this.getRepository().facet(DockerContentFacet.class);
            Optional<FluentAsset> manifestAsset = dockerContentFacet.findAsset(listedManifestName);
            if (!manifestAsset.isPresent()) {
                this.log.debug("Cannot find manifest with name: {}", (Object)listedManifestName);
            } else {
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try (Content content = manifestAsset.get().download();){
                        V2Manifest v2Manifest = this.v2ManifestUtil.readManifest(() -> ((Content)content).openInputStream(), asset.path(), asset.kind());
                        usedLayerDigests.addAll(v2Manifest.referencedDigests().stream().map(DockerDigest::toString).collect(Collectors.toList()));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | V2Exception.ManifestInvalid e) {
                    this.log.error("Failed to deserialize manifest with name: {}, skipping...", (Object)listedManifestName, (Object)e);
                }
            }
            if (taggedManifestDigests == null) continue;
            taggedManifestDigests.addAll(listedManifests.stream().map(DockerDigest::toString).collect(Collectors.toList()));
        }
    }

    private String getListedManifestName(FluentAsset manifestListAsset, DockerDigest listedManifest) {
        return String.valueOf(manifestListAsset.path().substring(0, manifestListAsset.path().lastIndexOf("/") + 1)) + listedManifest.toString();
    }
}

