/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.AssetBlobValidator;
import org.sonatype.nexus.repository.content.facet.AssetBlobValidators;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.utils.HardLinkHelper;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.docker.internal.datastore.store.DockerForeignLayersDAO;
import org.sonatype.nexus.repository.docker.internal.datastore.store.DockerForeignLayersData;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="docker")
public class DockerContentFacetImpl
extends ContentFacetSupport
implements DockerContentFacet {
    private static final String STORAGE_ATTRIBUTE = "storage";
    private static final String LATEST_POLICY_STORAGE_ATTRIBUTE = "latestPolicy";
    private static final String LATEST = "/latest";
    private static final String MANIFEST_SHA256 = "manifests/sha256";
    private static final String P_NAME = "name";
    private static final String AS_TEXT = "::text";
    private static final String LAST_UPDATED = "last_updated";
    private static final String V1_CHILD_ASSETS_FILTER = String.format("%s LIKE #{filterParams.h2_parent_pattern} OR %s LIKE #{filterParams.postgres_parent_pattern}", "attributes::text", "attributes::text");
    private static final int BATCH_SIZE = 1000;
    private final HashAlgorithmHelper hashAlgorithmHelper;
    private final HardLinkHelper hardLinkHelper;
    private final AssetBlobValidators assetBlobValidators;

    @Inject
    public DockerContentFacetImpl(@Named(value="docker") FormatStoreManager formatStoreManager, HashAlgorithmHelper hashAlgorithmHelper, HardLinkHelper hardLinkHelper, AssetBlobValidators assetBlobValidators) {
        super(formatStoreManager);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
        this.hardLinkHelper = (HardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.assetBlobValidators = (AssetBlobValidators)Preconditions.checkNotNull((Object)assetBlobValidators);
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (writePolicy == WritePolicy.ALLOW_ONCE && (this.isLatestPolicy() && asset.path().endsWith(LATEST) || this.isManifestAndSha256Manifest(asset))) {
            return WritePolicy.ALLOW;
        }
        return writePolicy;
    }

    private boolean isLatestPolicy() {
        return ((Map)this.repository().getConfiguration().getAttributes().get(STORAGE_ATTRIBUTE)).getOrDefault(LATEST_POLICY_STORAGE_ATTRIBUTE, false);
    }

    private boolean isManifestAndSha256Manifest(Asset asset) {
        return AssetKind.MANIFEST.name().equals(asset.kind()) && asset.path().contains(MANIFEST_SHA256);
    }

    @Override
    public Optional<FluentAsset> findAsset(String path) {
        return this.assets().path(path).find();
    }

    @Override
    public Optional<FluentComponent> findComponentByNameAndTag(String name, String tag) {
        return this.components().name(name).version(tag).find();
    }

    @Override
    public Iterable<FluentComponent> findComponentsByName(String name) {
        String where = String.format("%s=#{filterParams.nameFilter}", P_NAME);
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put("nameFilter", name);
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.components().byFilter(where, sqlParams)).browse(arg_0, arg_1));
    }

    @Override
    public Optional<Content> get(String path) {
        Optional<Content> content = Optional.empty();
        Optional<FluentAsset> asset = this.findAsset(path);
        if (asset.isPresent()) {
            NestedAttributesMap assetAttributes = asset.get().attributes();
            Content assetContent = asset.get().markAsDownloaded().download();
            String digest = (String)assetAttributes.child("docker").get("content_digest");
            if (digest != null) {
                assetContent.getAttributes().set("Docker-Content-Digest", (Object)digest);
            }
            content = Optional.of(assetContent);
        }
        return content;
    }

    @Override
    public Iterable<FluentAsset> findAssets(String filter, Map<String, Object> filterParams) {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byFilter(filter, filterParams)).browse(arg_0, arg_1));
    }

    @Override
    public Continuation<FluentAsset> findAssets(String filter, Map<String, Object> filterParams, String continuationToken) {
        FluentQuery fluentAssetsQuery = this.assets().byFilter(filter, filterParams);
        return fluentAssetsQuery.browse(1000, continuationToken);
    }

    private Content saveAssetWithAttributes(String path, @Nullable DockerDigest digest, TempBlob blob, Payload content, AssetKind assetKind, Map<String, Object> attributes, @Nullable FluentComponent component) {
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(assetKind.name());
        if (component != null) {
            assetBuilder.component((Component)component);
        }
        FluentAsset asset = assetBuilder.blob(blob).save();
        HashCode contentDigest = (HashCode)blob.getHashes().get(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM);
        return this.saveAssetWithAttributes(asset, digest, contentDigest, content, assetKind, attributes);
    }

    private Content saveAsset(String path, Blob blob, Map<HashAlgorithm, HashCode> checksums, Payload content, AssetKind assetKind) {
        FluentAssetBuilder assetBuilder = this.assets().path(path).kind(assetKind.name());
        FluentAsset asset = assetBuilder.blob(blob, checksums).save();
        HashCode contentDigest = checksums.get(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM);
        return this.saveAssetWithAttributes(asset, null, contentDigest, content, assetKind, Maps.newHashMap());
    }

    private Content saveAssetWithAttributes(FluentAsset asset, @Nullable DockerDigest digest, HashCode hashCode, Payload content, AssetKind assetKind, Map<String, Object> attributes) {
        if (this.isNewRepositoryContent((RepositoryContent)asset) || digest != null && !digest.toString().equals(asset.attributes("docker").get("content_digest"))) {
            if (assetKind == AssetKind.BLOB && this.isInvalidBlobDigest(digest, hashCode)) {
                throw new V2Exception.DigestInvalid("digest mismatch");
            }
            if (digest != null) {
                attributes.put("content_digest", digest.toString());
            } else if (hashCode != null) {
                attributes.put("content_digest", new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), hashCode.toString()).toString());
            }
            asset.withAttribute("docker", attributes);
        }
        asset.markAsCached(content);
        Content assetContent = asset.download();
        String contentDigest = (String)asset.attributes().child("docker").get("content_digest", String.class);
        if (contentDigest != null) {
            assetContent.getAttributes().set("Docker-Content-Digest", (Object)contentDigest);
        }
        return assetContent;
    }

    private FluentComponent getOrCreateComponent(String name, String tag, Map<String, Object> attributes) {
        FluentComponent component = this.components().name(name).version(tag).getOrCreate();
        if (this.isNewRepositoryContent((RepositoryContent)component)) {
            attributes.put("imageName", name);
            attributes.put("imageTag", tag);
        }
        Map componentAttributes = component.attributes().child("docker").backing();
        componentAttributes.putAll(attributes);
        component.withAttribute("docker", (Object)componentAttributes);
        return component;
    }

    @Override
    public Content putHardLinkedBlob(String path, Payload content, AssetKind assetKind, Map<String, Object> attributes) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.blobs().ingest(content, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.saveAssetWithAttributes(path, null, blob, content, assetKind, attributes, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putHardLinkedBlob(String path, TempBlob blob, Payload content, AssetKind assetKind, Map<String, Object> attributes) {
        return this.saveAssetWithAttributes(path, null, blob, content, assetKind, attributes, null);
    }

    @Override
    public Content putHardLinkedBlob(String path, Blob blob, Map<HashAlgorithm, HashCode> checksums, Payload content, AssetKind assetKind) {
        return this.saveAsset(path, blob, checksums, content, assetKind);
    }

    @Override
    public Content putTag(String name, String tag, Payload payload, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob blob = this.blobs().ingest(payload, DockerFacetUtils.HASH_ALGORITHMS);){
            FluentComponent tagComponent = this.getOrCreateComponent(name, tag, componentAttributes);
            return this.saveAssetWithAttributes(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1tagName(name, tag)), null, blob, payload, AssetKind.TAG, assetAttributes, tagComponent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putManifestByTag(String name, String tag, DockerDigest digest, Payload content) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.blobs().ingest(content, DockerFacetUtils.HASH_ALGORITHMS);){
            FluentComponent tagComponent = this.getOrCreateComponent(name, tag, new HashMap<String, Object>());
            return this.saveAssetWithAttributes(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.tagName(name, tag)), digest, blob, content, AssetKind.MANIFEST, new HashMap<String, Object>(), tagComponent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putManifestByDigest(String name, DockerDigest digest, Payload content) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.blobs().ingest(content, DockerFacetUtils.HASH_ALGORITHMS);){
            String path = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.manifestName(name, digest));
            return this.assets().path(path).find().map(asset -> asset.blob().map(__ -> asset.markAsCached(content).download()).orElse(null)).orElseGet(() -> this.saveAssetWithAttributes(path, digest, blob, content, AssetKind.MANIFEST, new HashMap<String, Object>(), null));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putBlob(DockerDigest digest, Payload content, AssetKind assetKind, Map<String, Object> attributes) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.blobs().ingest(content, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.saveAssetWithAttributes(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(digest)), digest, blob, content, assetKind, attributes, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putHardLinkedBlob(File blobLocation, DockerDigest digest, Payload content, AssetKind assetKind) throws IOException {
        String assetPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(digest));
        String contentType = this.getContentType(blobLocation, assetPath);
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(blobLocation, DockerFacetUtils.HASH_ALGORITHMS);
        Blob blob = this.hardLinkHelper.ingestHardLink(this.getRepository(), blobLocation, (HashCode)checksums.get(HashAlgorithm.SHA1), contentType);
        return this.saveAsset(assetPath, blob, checksums, content, assetKind);
    }

    @Override
    public void putAncestry(String name, String layerId, List<String> ancestry) {
        String where = String.format("%s=#{filterParams.nameFilter} AND %s LIKE #{filterParams.layerId}", P_NAME, "attributes::text");
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put("nameFilter", name);
        sqlParams.put("layerId", "%docker%layerId%" + layerId + "%");
        FluentQuery fluentComponentFluentQuery = this.components().byFilter(where, sqlParams);
        Iterable tagComponents = Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)fluentComponentFluentQuery).browse(arg_0, arg_1));
        for (FluentComponent tagComponent : tagComponents) {
            Map formatAttributes = tagComponent.attributes().child("docker").backing();
            List currentAncestry = (List)formatAttributes.get("layerAncestry");
            if (currentAncestry != null && currentAncestry.equals(ancestry)) continue;
            formatAttributes.put("layerAncestry", ancestry);
            tagComponent.withAttribute("docker", (Object)formatAttributes);
        }
    }

    @Override
    public FluentAsset findAssetByContentDigest(DockerDigest digest) {
        String where = String.format("%s LIKE #{filterParams.digest}", "attributes::text");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("digest", "%docker%content_digest%" + digest + "%");
        Iterator<FluentAsset> assets = this.findAssets(where, parameters).iterator();
        return assets.hasNext() ? assets.next() : null;
    }

    @Override
    public Iterable<FluentAsset> findV1ChildAssets(String parentLayerId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("h2_parent_pattern", "%docker%parent\":\"" + parentLayerId + "\"%");
        parameters.put("postgres_parent_pattern", "%docker%parent\": \"" + parentLayerId + "\"%");
        return this.findAssets(V1_CHILD_ASSETS_FILTER, parameters);
    }

    @Override
    public List<String> getForeignLayerUrls(String digest) throws JsonProcessingException {
        Objects.requireNonNull(digest);
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataSession session = this.openSession();){
            DockerForeignLayersDAO dao = (DockerForeignLayersDAO)session.access(DockerForeignLayersDAO.class);
            DockerForeignLayersData foreignLayerUrls = dao.getForeignLayerUrls(digest);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            List list = foreignLayerUrls == null ? null : (List)mapper.readValue(foreignLayerUrls.getUrls(), (TypeReference)new TypeReference<List<String>>(){});
            return list;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Continuation<FluentComponent> getV1ComponentsBeforeOffset(OffsetDateTime offsetTime, String continuationToken) {
        String where = String.format("%s LIKE ('%s%s%s') AND %s < '%s'", "attributes::text", "%", "layerId", "%", LAST_UPDATED, offsetTime.toString());
        FluentQuery fluentComponentFluentQuery = this.components().byFilter(where, new HashMap());
        return fluentComponentFluentQuery.browse(1000, continuationToken);
    }

    @Override
    public void updateForeignLayerUrls(String digest, List<String> urls) throws JsonProcessingException {
        Objects.requireNonNull(digest);
        Objects.requireNonNull(urls);
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataSession session = this.openSession();){
            DockerForeignLayersDAO dao = (DockerForeignLayersDAO)session.access(DockerForeignLayersDAO.class);
            ObjectMapper mapper = new ObjectMapper();
            String urlsAsJsonString = mapper.writeValueAsString(urls);
            DockerForeignLayersData data = new DockerForeignLayersData();
            data.setDigest(digest);
            data.setUrls(urlsAsJsonString);
            dao.updateForeignLayerUrls(data);
            session.getTransaction().commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isNewRepositoryContent(RepositoryContent repositoryContent) {
        return repositoryContent.attributes().isEmpty();
    }

    private boolean isInvalidBlobDigest(DockerDigest digest, HashCode contentDigest) {
        return digest != null && contentDigest != null && !digest.toString().equals(new DockerDigest(DockerFacetUtils.DOCKER_DIGEST_ALGORITHM.name(), contentDigest.toString()).toString());
    }

    private String getContentType(File file, String contentName) {
        AssetBlobValidator assetBlobValidator = this.assetBlobValidators.selectValidator(this.getRepository());
        Boolean strictContentTypeValidation = (Boolean)this.getRepository().getConfiguration().attributes(STORAGE_ATTRIBUTE).get("strictContentTypeValidation", Boolean.class, (Object)Boolean.FALSE);
        Objects.requireNonNull(strictContentTypeValidation);
        return assetBlobValidator.determineContentType(strictContentTypeValidation.booleanValue(), () -> new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])), contentName, null);
    }
}

