/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="docker")
@Singleton
public class DockerComponentDirector
implements ContentDirector {
    private final V2ManifestUtil v2ManifestUtil;

    @Inject
    public DockerComponentDirector(V2ManifestUtil v2ManifestUtil) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        return !component.attributes().child("docker").contains("layerId");
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public Component beforeMove(Component component, List<? extends Asset> assets, Repository source, Repository destination) {
        List<String> assetNamesToCopy = this.getAssetsToCopy(source, component, assets);
        this.maybeCopyAssets(source, destination, assetNamesToCopy);
        return component;
    }

    private List<String> getAssetsToCopy(Repository source, Component component, List<? extends Asset> assets) {
        if (assets.size() != 1) {
            throw new IllegalStateException(String.format("Docker component must have exactly one asset; component: %s", component.name()));
        }
        Asset manifestAsset = assets.get(0);
        String manifestDigest = (String)manifestAsset.attributes().child("docker").get("content_digest", String.class);
        if (manifestDigest == null) {
            throw new IllegalStateException(String.format("Docker component asset must reference the manifest digest; component: %s, asset: %s", component.name(), manifestAsset.path()));
        }
        String manifestAssetName = String.format("/v2/%s/manifests/%s", component.name(), manifestDigest);
        DockerContentFacet facet = (DockerContentFacet)source.facet(DockerContentFacet.class);
        Optional<Content> content = facet.get(manifestAssetName);
        Content manifestContent = content.orElseThrow(() -> new IllegalStateException(String.format("Unable read asset: %s", manifestAssetName)));
        try {
            V2Manifest manifest = this.v2ManifestUtil.readManifest(() -> ((Content)manifestContent).openInputStream(), "manifest", manifestContent.getContentType());
            return Stream.concat(Stream.of(manifestAssetName), manifest.referencedDigests().stream().map(digest -> String.format("/v2/-/blobs/%s", digest.toString()))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable read manifest for component: %s", component.name()), e);
        }
    }

    private void maybeCopyAssets(Repository source, Repository destination, List<String> assetNamesToCopy) {
        DockerContentFacet sourceFacet = (DockerContentFacet)source.facet(DockerContentFacet.class);
        DockerContentFacet destinationFacet = (DockerContentFacet)destination.facet(DockerContentFacet.class);
        for (String assetName : assetNamesToCopy) {
            FluentAsset sourceAsset = sourceFacet.findAsset(assetName).orElseThrow(() -> new IllegalStateException(String.format("Unable read asset: %s", assetName)));
            TempBlob blob = destinationFacet.blobs().ingest((Payload)sourceAsset.download(), DockerFacetUtils.HASH_ALGORITHMS);
            Optional<FluentAsset> destinationAsset = destinationFacet.findAsset(sourceAsset.path());
            if (destinationAsset.isPresent()) continue;
            destinationFacet.assets().path(sourceAsset.path()).kind(sourceAsset.kind()).blob(blob).save().withAttribute("docker", (Object)sourceAsset.attributes().child("docker").backing());
        }
    }
}

