/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerAssetSearchSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;

@Named
public class DockerAssetSearch
extends DockerAssetSearchSupport {
    private final SearchService searchService;

    @Inject
    public DockerAssetSearch(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    @Nullable
    public Set<String> findByContentDigest(DockerDigest digest, String repositoryName) {
        TreeSet<String> manifests = new TreeSet<String>();
        SearchRequest request = SearchRequest.builder().searchFilter("assets.attributes.docker.content_digest", digest.toString()).repository(repositoryName).disableAuthorization().build();
        for (ComponentSearchResult hit : this.searchService.browse(request)) {
            AssetSearchResult matchingAsset = this.getSearchAssetMatchingContentDigest(hit, digest);
            if (matchingAsset == null) continue;
            manifests.add(matchingAsset.getPath());
        }
        return manifests;
    }
}

