/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

public abstract class V1Exception
extends RuntimeException {
    private final int httpCode;

    protected V1Exception(String message) {
        this(message, 400);
    }

    protected V1Exception(String message, int httpCode) {
        super(message);
        this.httpCode = httpCode;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public static class FailedToRetrieveToken
    extends V1Exception {
        public FailedToRetrieveToken() {
            super("Failed to retrieve authentication token from configured index", 502);
        }
    }

    public static class ImageAlreadyExists
    extends V1Exception {
        public ImageAlreadyExists() {
            this("Image already exists");
        }

        public ImageAlreadyExists(String message) {
            super(message, 409);
        }
    }

    public static class ImageNotFound
    extends V1Exception {
        public ImageNotFound() {
            super("Image not found", 404);
        }
    }

    public static class ImagesNotFound
    extends V1Exception {
        public ImagesNotFound() {
            super("images not found", 404);
        }
    }

    public static class InvalidChecksum
    extends V1Exception {
        public InvalidChecksum(String message) {
            super(message);
        }
    }

    public static class InvalidImageId
    extends V1Exception {
        public InvalidImageId() {
            super("Invalid image ID", 404);
        }
    }

    public static class InvalidJson
    extends V1Exception {
        public InvalidJson() {
            super("Invalid JSON");
        }

        public InvalidJson(String message) {
            super(message);
        }
    }

    public static class InvalidLayerMetadata
    extends V1Exception {
        public InvalidLayerMetadata(String message) {
            super(message);
        }
    }

    public static class InvalidResponseFromRemote
    extends V1Exception {
        private final String url;
        private final String path;
        private final Throwable cause;

        public InvalidResponseFromRemote(Throwable cause, String url, String path) {
            super(cause.getMessage(), 404);
            this.cause = cause;
            this.url = url;
            this.path = path;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public synchronized Throwable getCause() {
            return this.cause;
        }
    }

    public static class InvalidTagName
    extends V1Exception {
        public InvalidTagName() {
            super("Invalid tag name (must match '^[\\w][\\w.-]{0,127}$')");
        }
    }

    public static class OldDocker
    extends V1Exception {
        public OldDocker() {
            super("This endpoint does not support Docker daemons older than 0.10", 412);
        }

        public OldDocker(String message) {
            super(String.valueOf(message) + ". If you are using the Docker daemon, you should upgrade to version 0.10 or later", 412);
        }
    }

    public static class RepositoryNotFound
    extends V1Exception {
        public RepositoryNotFound() {
            super("Repository not found", 404);
        }
    }

    public static class SearchEndpointNotFound
    extends V1Exception {
        public SearchEndpointNotFound() {
            super("Search endpoint not found", 404);
        }
    }

    public static class TagNotFound
    extends V1Exception {
        public TagNotFound() {
            super("Tag not found", 404);
        }
    }
}

