/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import java.util.Arrays;
import java.util.Collection;

public enum MediaType {
    IMAGE_INDEX("application/vnd.oci.image.index.v1+json", "application/vnd.docker.distribution.manifest.list.v2+json"),
    IMAGE_MANIFEST("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json");

    public final String ociMediaType;
    public final String dockerMediaType;

    private MediaType(String ociMediaType, String dockerMediaType) {
        this.ociMediaType = ociMediaType;
        this.dockerMediaType = dockerMediaType;
    }

    public boolean matches(String mediaType) {
        return this.ociMediaType.equals(mediaType) || this.dockerMediaType.equals(mediaType);
    }

    public boolean matchesAny(Collection<String> mediaTypes) {
        if (mediaTypes == null) {
            return false;
        }
        return mediaTypes.stream().flatMap(it -> Arrays.stream(it.split(","))).map(s -> s.split(";", 2)[0]).map(String::trim).anyMatch(this::matches);
    }
}

