/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.docker.internal.V2TagListResult;
import org.sonatype.nexus.repository.proxy.ProxyFacet;

@Named
@Facet.Exposed
public class DockerV2ProxyTagsRequestExecutorFacet
extends FacetSupport {
    private final ObjectMapper objectMapper;

    @Inject
    public DockerV2ProxyTagsRequestExecutorFacet(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public HttpResponse execute(HttpContext httpContext, HttpClient httpClient, HttpRequestBase request) throws IOException {
        Objects.requireNonNull(httpClient);
        ArrayList<V2TagListResult> v2TagListResults = new ArrayList<V2TagListResult>();
        HttpResponse response = this.getTagListResults(v2TagListResults, httpContext, httpClient, request);
        if (response.getStatusLine().getStatusCode() != 200) {
            return response;
        }
        V2TagListResult result = this.mergeV2TagListResults(v2TagListResults);
        return this.buildResponseFrom(response, this.objectMapper.writeValueAsBytes((Object)result));
    }

    private HttpResponse buildResponseFrom(HttpResponse response, byte[] contentBytes) {
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        basicHttpEntity.setContent((InputStream)new ByteArrayInputStream(contentBytes));
        basicHttpEntity.setContentType(response.getEntity().getContentType());
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(response.getStatusLine());
        basicHttpResponse.setEntity((HttpEntity)basicHttpEntity);
        return basicHttpResponse;
    }

    private V2TagListResult mergeV2TagListResults(List<V2TagListResult> tags) {
        V2TagListResult first = tags.get(0);
        V2TagListResult result = new V2TagListResult();
        result.setName(first.getName());
        List<String> tagsResult = tags.stream().flatMap(tagListResult -> tagListResult.getTags().stream()).sorted().distinct().collect(Collectors.toList());
        result.setTags(tagsResult);
        return result;
    }

    private V2TagListResult deserializeResponseHttpEntity(HttpEntity httpEntity) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream content = httpEntity.getContent();){
                return (V2TagListResult)this.objectMapper.readValue(content, V2TagListResult.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            throw e;
        }
    }

    private HttpResponse getTagListResults(List<V2TagListResult> results, HttpContext httpContext, HttpClient httpClient, HttpRequestBase request) throws IOException {
        HttpResponse response;
        block4: {
            HttpResponse httpResponse;
            response = null;
            try {
                response = httpClient.execute((HttpUriRequest)request, httpContext);
                if (response.getStatusLine().getStatusCode() == 200) break block4;
                this.log.debug("Failed request to {} with status {}", (Object)request.getURI(), (Object)response.getStatusLine());
                httpResponse = this.buildResponseFrom(response, IOUtils.toByteArray((InputStream)response.getEntity().getContent()));
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
            HttpClientUtils.closeQuietly((HttpResponse)response);
            return httpResponse;
        }
        results.add(this.deserializeResponseHttpEntity(response.getEntity()));
        Optional<HttpRequestBase> nextRequest = Optional.of(response).map(this::extractLinkUriFromPageLink).map(HttpGet::new);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        if (nextRequest.isPresent()) {
            return this.getTagListResults(results, httpContext, httpClient, nextRequest.get());
        }
        return response;
    }

    private URI extractLinkUriFromPageLink(HttpResponse response) {
        Header linkHeader = response.getFirstHeader("Link");
        if (linkHeader == null) {
            return null;
        }
        String value = linkHeader.getValue();
        int from = value.indexOf(60);
        int to = value.indexOf(62);
        if (from == -1 || to == -1) {
            return null;
        }
        String url = value.substring(from + 1, to);
        URI remoteUrl = ((ProxyFacet)this.facet(ProxyFacet.class)).getRemoteUrl();
        return remoteUrl.resolve(url);
    }
}

