/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.rapture.StateContributor;

@Named
@Singleton
public class DockerSubdomainFeatureControlService
implements StateContributor {
    private static final String PRO_LICENSE = "PRO";
    private static final String DOCKER_SUBDOMAIN_ENABLED = "dockerSubdomainEnabled";
    private final boolean isFeatureAllowed;

    @Inject
    public DockerSubdomainFeatureControlService(ApplicationVersion applicationVersion) {
        this.isFeatureAllowed = PRO_LICENSE.equals(applicationVersion.getEdition());
    }

    public boolean isFeatureAllowed() {
        return this.isFeatureAllowed;
    }

    @Nullable
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)DOCKER_SUBDOMAIN_ENABLED, (Object)this.isFeatureAllowed());
    }
}

