/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerProxyFacet;
import org.sonatype.nexus.repository.docker.internal.DockerV2ProxyTagsRequestExecutorFacet;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V1HandlersSupport;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.auth.DockerAuthHttpClientContext;
import org.sonatype.nexus.repository.docker.internal.auth.DockerTokenDecoder;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.BypassHttpErrorException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;
import org.sonatype.nexus.validation.constraint.Url;

public abstract class DockerProxyFacetSupport
extends ContentProxyFacetSupport
implements DockerProxyFacet {
    protected final V2ManifestUtil v2ManifestUtil;
    protected boolean verifyManifestDigest;
    protected Config config;
    private final ConstraintViolationFactory constraintViolationFactory;

    protected DockerProxyFacetSupport(V2ManifestUtil v2ManifestUtil, ConstraintViolationFactory constraintViolationFactory, boolean verifyManifestDigest) {
        this.v2ManifestUtil = v2ManifestUtil;
        this.constraintViolationFactory = Objects.requireNonNull(constraintViolationFactory);
        this.verifyManifestDigest = verifyManifestDigest;
    }

    public boolean shouldIncludeLibraryNamespace() {
        return this.config.indexType.equals((Object)Config.IndexType.HUB);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, "dockerProxy", Config.class, new Class[0]);
        this.validateWhitelistPatterns(configuration, this.constraintViolationFactory, this.log);
        this.moveUIWhitelistPatterns(configuration);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "dockerProxy", Config.class);
        if (this.config.indexUrl != null && !this.config.indexUrl.getPath().endsWith("/")) {
            this.config.indexUrl = this.config.indexUrl.resolve(String.valueOf(this.config.indexUrl.getPath()) + "/");
        }
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected String getUrl(Context context) {
        Parameters parameters;
        String url = context.getRequest().getPath();
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (AssetKind.SEARCH == assetKind && !(parameters = context.getRequest().getParameters()).isEmpty()) {
            url = String.valueOf(url) + "?" + String.join((CharSequence)"&", Iterables.transform((Iterable)parameters, (Function)new Function<Map.Entry<String, String>, String>(){

                @Nullable
                public String apply(Map.Entry<String, String> input) {
                    return String.valueOf(input.getKey()) + "=" + input.getValue();
                }
            }));
        }
        return url.substring(1);
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        AssetKind assetKind;
        HttpContext tokenContext = this.prepareTokenAuthentication(context);
        HttpRequestBase httpRequest = this.prepareRequest(tokenContext, context, request, assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class)));
        HttpResponse httpResponse = DockerFacetUtils.maybeExecuteConditionalHead(httpRequest, client, tokenContext);
        if (httpResponse != null) {
            return httpResponse;
        }
        HttpResponse response = AssetKind.BLOB == assetKind ? this.executeBlobRequest(context, client, tokenContext, request) : (AssetKind.TAG_LIST == assetKind ? ((DockerV2ProxyTagsRequestExecutorFacet)this.facet(DockerV2ProxyTagsRequestExecutorFacet.class)).execute(tokenContext, client, request) : client.execute((HttpUriRequest)request, tokenContext));
        DockerFacetUtils.checkResponseStatus(context, assetKind, request, response);
        return response;
    }

    protected abstract List<String> getForeignLayerUrls(String var1) throws JsonProcessingException;

    protected abstract void updateForeignLayerUrls(String var1, List<String> var2) throws JsonProcessingException;

    protected abstract DockerDigest manifestDigestFromContent(Content var1) throws IOException;

    protected Content createContent(Context context, HttpResponse response) {
        DockerFacetUtils.setAttributeFromHeader(context, response, "Docker-Content-Digest");
        return super.createContent(context, response);
    }

    protected void maybeValidateOnDigest(TokenMatcher.State state, TempBlob tempBlob) {
        Map tokens = state.getTokens();
        String requiredAlg = (String)tokens.get("digestAlg");
        String requiredDigest = (String)tokens.get("digestHex");
        if (this.verifyManifestDigest && Objects.nonNull(requiredAlg) && Objects.nonNull(requiredDigest) && !requiredDigest.equals(this.getDigest(requiredAlg, tempBlob))) {
            throw new V2Exception.DigestInvalidByMismatch();
        }
    }

    protected Content doGet(Context context, @Nullable Content staleContent) throws IOException {
        Content content;
        block6: {
            content = staleContent;
            AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
            try {
                content = super.doGet(context, staleContent);
                if (content == null || !context.getAttributes().contains(TokenMatcher.State.class) || !assetKind.equals((Object)AssetKind.MANIFEST)) break block6;
                TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
                String name = V2Handlers.requireName(state);
                String tag = V2Handlers.tag(state);
                V2Manifest.SchemaVersion clientPreference = V2Handlers.detectClientSchemaVersionPreference(context);
                if (DockerFacetUtils.isTrue(this.config.cacheForeignLayers)) {
                    this.identifyForeignLayers(content);
                }
                if (!this.v2ManifestUtil.shouldDowngrade(content, name, clientPreference)) break block6;
                this.log.debug("Performing downgrade of content to schemaVersion = 1 for {}", (Object)name);
                DockerDigest configDigest = this.v2ManifestUtil.findConfigDigest(content, name);
                String path = DockerFacetUtils.blobAssetRequest(configDigest, name);
                Request getRequest = new Request.Builder().action("GET").path(path).build();
                try {
                    Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(getRequest);
                    if (!response.getStatus().isSuccessful()) {
                        this.log.error("Manifest configuration file download failed: {}", (Object)response.getStatus());
                        throw new V2Exception.BlobNotFound(configDigest);
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed to retrieve configuration file from remote on path: {}", (Object)path, (Object)e);
                    throw new V2Exception.BlobNotFound(configDigest);
                }
                return this.v2ManifestUtil.mayDowngrade(content, name, tag, clientPreference, this.getRepository());
            }
            catch (V1Exception | V2Exception | BypassHttpErrorException e) {
                this.logContentOrThrow(content, context, null, e);
            }
        }
        return content;
    }

    protected void identifyForeignLayers(Content manifestContent) throws IOException {
        this.log.debug("Proxy configured to cache foreign layers");
        V2Manifest manifest = this.v2ManifestUtil.readManifest(() -> ((Content)manifestContent).openInputStream(), "manifest", manifestContent.getContentType());
        manifest.getLayers().stream().filter(layer -> Objects.equals(layer.getMediaType(), "application/vnd.docker.image.rootfs.foreign.diff.tar.gzip")).filter(layer -> layer.getUrls() != null).forEach(layer -> {
            DockerDigest digest = DockerDigest.parse(layer.getDigest());
            this.log.debug("Storing foreign layer digest: {} with URLs: {}", (Object)digest, layer.getUrls());
            try {
                this.updateForeignLayerUrls(digest.toString(), this.filterForeignLayerUrls(layer.getUrls()));
            }
            catch (Exception e) {
                this.log.error("Unable to store foreign layer URL information for digest: {}", (Object)digest, (Object)e);
            }
        });
    }

    protected DockerDigest fetchTagDigestByContentDigest(Context context, String tag, AttributesMap contentAttributes, TempBlob manifestContent) throws IOException {
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent);
        if (!this.verifyManifestDigest) {
            this.log.debug("Manifest Content Digest verification is disabled, using calculated digest as representing valid content.");
            return manifestDigest;
        }
        if (this.headerDigestMatched(manifestDigest, context, contentAttributes)) {
            return manifestDigest;
        }
        this.log.debug("Unable to get digest of tag {} by response header Docker-Content-Digest or ETag. Calculating digest from remote fetch.", (Object)tag);
        try {
            Content contentByHash = this.fetch(this.urlToRemoteManifestDigest(context, tag, manifestDigest), context, null);
            return this.manifestDigestFromContent(contentByHash);
        }
        catch (V2Exception e) {
            if (e.getHttpCode() == 404) {
                this.log.error("Could not fetch the tag {} by its digest {}", new Object[]{tag, manifestDigest, e});
                throw new V2Exception.DigestInvalidByMismatch();
            }
            throw e;
        }
    }

    protected String urlToRemoteManifestDigest(Context context, String tag, DockerDigest manifestDigest) {
        String requestPath = context.getRequest().getPath();
        int startIndex = requestPath.startsWith("/") ? 1 : 0;
        return String.valueOf(requestPath.substring(startIndex, requestPath.lastIndexOf(tag))) + manifestDigest.toString();
    }

    protected boolean headerDigestMatched(DockerDigest manifestDigest, Context context, AttributesMap contentAttributes) {
        String dockerContentDigest = (String)context.getAttributes().get("Docker-Content-Digest", String.class);
        if (Objects.nonNull(dockerContentDigest) && manifestDigest.equals(DockerDigest.parse(dockerContentDigest))) {
            return true;
        }
        String eTag = (String)contentAttributes.get("etag", String.class);
        return Objects.nonNull(eTag) && manifestDigest.equals(DockerDigest.parse(eTag));
    }

    private HttpRequestBase prepareRequest(HttpContext tokenContext, Context context, HttpRequestBase request, AssetKind assetKind) {
        if (AssetKind.IMAGES == assetKind) {
            request.setURI(this.getIndexUri(this.config).resolve(this.getUrl(context)));
            request.addHeader("X-Docker-Token", Boolean.TRUE.toString());
            if (Config.IndexType.REGISTRY != this.config.indexType) {
                tokenContext.setAttribute("nexus.httpclient.ssl.trustStore", (Object)DockerFacetUtils.isTrue(this.config.useTrustStoreForIndexAccess));
            }
        } else if (AssetKind.SEARCH == assetKind) {
            request.setURI(this.getIndexUri(this.config).resolve(this.getUrl(context)));
        } else if (AssetKind.MANIFEST == assetKind) {
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v2+json");
            request.addHeader("Accept", "application/vnd.oci.image.manifest.v1+json");
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v1+prettyjws");
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.v1+json");
            request.addHeader("Accept", "application/json");
            request.addHeader("Accept", "application/vnd.docker.distribution.manifest.list.v2+json");
            request.addHeader("Accept", "application/vnd.oci.image.index.v1+json");
            Optional.ofNullable(context.getRequest().getHeaders().getAll("Accept")).orElse(Collections.emptyList()).forEach(clientAcceptHeader -> request.addHeader("Accept", clientAcceptHeader));
        }
        return request;
    }

    private HttpResponse executeBlobRequest(Context context, HttpClient client, HttpContext httpContext, HttpRequestBase request) throws IOException {
        TokenMatcher.State state = V2Handlers.matcherState(context);
        String digest = String.valueOf((String)state.getTokens().get("digestAlg")) + ":" + (String)state.getTokens().get("digestHex");
        List<String> foreignLayerUrls = this.getForeignLayerUrls(digest);
        return foreignLayerUrls != null && DockerFacetUtils.isTrue(this.config.cacheForeignLayers) ? DockerFacetUtils.executeForeignLayerRequest(foreignLayerUrls, digest, client, httpContext, request) : client.execute((HttpUriRequest)request, httpContext);
    }

    private HttpContext prepareTokenAuthentication(final Context context) {
        return new DockerAuthHttpClientContext(this.getRemoteUrl()){

            @Override
            protected String retrieveToken() throws AuthenticationException {
                return DockerProxyFacetSupport.this.retrieveToken(context, DockerProxyFacetSupport.this.config, DockerProxyFacetSupport.this.getRepository());
            }

            @Override
            protected String retrieveBearerToken(String realm, String service, String scope) throws AuthenticationException {
                return DockerProxyFacetSupport.this.retrieveBearerToken(realm, service, scope, DockerProxyFacetSupport.this.getRepository(), DockerProxyFacetSupport.this.log);
            }
        };
    }

    private List<String> filterForeignLayerUrls(List<String> urls) {
        if (this.config.foreignLayerUrlWhitelist == null || this.config.foreignLayerUrlWhitelist.isEmpty()) {
            this.log.warn("Repository: {} is configured to cache foreign layers, but URL whitelist has no values; NXRM will not be able to cache any foreign layers", (Object)this.getRepository());
            return Collections.emptyList();
        }
        ArrayList filtered = Lists.newArrayList();
        urls.forEach(url -> {
            if (this.config.foreignLayerUrlWhitelist.stream().anyMatch(url::matches)) {
                filtered.add(url);
            } else {
                this.log.warn("URL '{}' has been found as a foreign layer URL, but does not match any configured whitelist patterns for Foreign Layer Caching on repository: {}", url, (Object)this.getRepository().getName());
            }
        });
        return filtered;
    }

    private String getDigest(String algorithm, TempBlob tempBlob) {
        HashAlgorithm hashAlgorithm = (HashAlgorithm)HashAlgorithm.getHashAlgorithm((String)algorithm).orElseThrow(V2Exception.DigestInvalidByMismatch::new);
        return Optional.ofNullable((HashCode)tempBlob.getHashes().get(hashAlgorithm)).orElseThrow(V2Exception.DigestInvalidByMismatch::new).toString();
    }

    private String retrieveToken(Context context, Config config, Repository repository) throws AuthenticationException {
        String token = (String)context.getAttributes().get("X-Docker-Token", String.class);
        if (token == null) {
            HttpResponse response = null;
            URI indexUri = this.getIndexUri(config);
            try {
                try {
                    TokenMatcher.State state = V2Handlers.matcherState(context);
                    HttpClient client = ((HttpClientFacet)repository.facet(HttpClientFacet.class)).getHttpClient();
                    HttpGet request = new HttpGet(indexUri.resolve(DockerFacetUtils.v1imagesIndexName(V1HandlersSupport.name(state))));
                    request.addHeader("X-Docker-Token", "true");
                    response = DockerFacetUtils.executeOK(indexUri.toASCIIString(), client, request);
                    if (response.getFirstHeader("X-Docker-Token") == null) {
                        throw new AuthenticationException(String.format("Could not retrieve token from %s. %s response header not set", indexUri, "X-Docker-Token"));
                    }
                    token = response.getFirstHeader("X-Docker-Token").getValue();
                    context.getAttributes().set("X-Docker-Token", (Object)token);
                }
                catch (IOException e) {
                    throw new AuthenticationException(String.format("Could not retrieve token from %s", indexUri), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        return token;
    }

    private URI getIndexUri(Config config) {
        switch (config.indexType) {
            case REGISTRY: {
                return this.getRemoteUrl();
            }
            case HUB: {
                return DockerFacetUtils.getHubUri();
            }
        }
        return config.indexUrl;
    }

    private String retrieveBearerToken(String realm, String service, String scope, Repository repository, Logger log) throws AuthenticationException {
        String string;
        HttpResponse response = null;
        try {
            HttpClient client = ((HttpClientFacet)repository.facet(HttpClientFacet.class)).getHttpClient();
            log.trace("Retrieving bearer token for realm: {}, service: {}, scope: {}", new Object[]{realm, service, scope});
            HttpGet request = new HttpGet(DockerFacetUtils.buildUrl(realm, service, scope, repository));
            Header preemptiveBasicAuth = ((HttpClientFacet)repository.facet(HttpClientFacet.class)).createBasicAuthHeader();
            if (preemptiveBasicAuth != null) {
                request.setHeader(preemptiveBasicAuth);
            }
            response = DockerFacetUtils.executeOK(realm, client, request);
            String token = DockerFacetUtils.readToken(response, realm);
            if (log.isTraceEnabled()) {
                log.trace("Docker token is: {}", (Object)DockerTokenDecoder.decodeToLoggable(token));
            }
            string = token;
        }
        catch (IOException e) {
            try {
                throw new AuthenticationException(String.format("Could not retrieve bearer token from %s", realm), (Throwable)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return string;
    }

    private void validateWhitelistPatterns(Configuration configuration, ConstraintViolationFactory constraintViolationFactory, Logger log) {
        HashSet violations = new HashSet();
        BiConsumer<String, String> validateRegex = (regex, key) -> {
            try {
                Pattern.compile(regex);
            }
            catch (Exception e) {
                violations.add(constraintViolationFactory.createViolation("attributes.dockerProxy." + key, "Invalid regex: " + e.getMessage()));
            }
        };
        configuration.attributes("dockerProxy").keys().stream().filter(key -> key.startsWith("whitelistUrl")).forEach(key -> validateRegex.accept((String)configuration.attributes("dockerProxy").require(key, String.class), (String)key));
        if (configuration.attributes("dockerProxy").contains("foreignLayerUrlWhitelist")) {
            ((Iterable)configuration.attributes("dockerProxy").require("foreignLayerUrlWhitelist", Iterable.class)).forEach(regex -> validateRegex.accept((String)regex, "foreignLayerUrlWhitelist"));
        }
        ConstraintViolations.maybePropagate(violations, (Logger)log);
    }

    private void moveUIWhitelistPatterns(Configuration configuration) {
        List whitelist = (List)configuration.attributes("dockerProxy").get("foreignLayerUrlWhitelist", List.class);
        if (whitelist == null) {
            whitelist = Lists.newArrayList();
            configuration.attributes("dockerProxy").set("foreignLayerUrlWhitelist", (Object)whitelist);
        }
        Iterator keys = configuration.attributes("dockerProxy").keys().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("whitelistUrl")) continue;
            if (!whitelist.contains(configuration.attributes("dockerProxy").require(key, String.class))) {
                whitelist.add((String)configuration.attributes("dockerProxy").require(key, String.class));
            }
            keys.remove();
        }
    }

    public static class Config {
        public static final String UI_WHITELIST_URL_PREFIX = "whitelistUrl";
        public static final String FOREIGN_LAYER_WHITELIST_PROP = "foreignLayerUrlWhitelist";
        @NotNull
        public IndexType indexType;
        @Url
        public URI indexUrl;
        public Boolean useTrustStoreForIndexAccess;
        public Boolean cacheForeignLayers;
        public List<String> foreignLayerUrlWhitelist;

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "indexType=" + (Object)((Object)this.indexType) + ", indexUrl=" + this.indexUrl + ", useTrustStoreForIndexAccess=" + this.useTrustStoreForIndexAccess + ", cacheForeignLayers=" + this.cacheForeignLayers + ", foreignLayerUrlWhitelist=" + this.foreignLayerUrlWhitelist + '}';
        }

        public static enum IndexType {
            REGISTRY,
            HUB,
            CUSTOM;

        }
    }
}

