/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import javax.inject.Singleton;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Singleton
public class DockerNotFound {
    public Response generate(Context context) {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case IMAGES: {
                throw new V1Exception.ImagesNotFound();
            }
            case TAGS: {
                throw new V1Exception.RepositoryNotFound();
            }
            case TAG: {
                throw new V1Exception.TagNotFound();
            }
            case LAYER_METADATA: 
            case LAYER_CONTENT: 
            case LAYER_ANCESTRY: {
                throw new V1Exception.ImageNotFound();
            }
            case SEARCH: {
                throw new V1Exception.SearchEndpointNotFound();
            }
            case MANIFEST: {
                throw this.manifestUnknown(context);
            }
            case BLOB: {
                throw new V2Exception.BlobNotFound(V2Handlers.requireDigest(V2Handlers.matcherState(context)));
            }
        }
        return HttpResponses.notFound();
    }

    private V2Exception manifestUnknown(Context context) {
        TokenMatcher.State state = V2Handlers.matcherState(context);
        String tag = V2Handlers.tag(state);
        if (tag != null) {
            return new V2Exception.ManifestUnknownByTag(V2Handlers.requireName(state, false), tag);
        }
        return new V2Exception.ManifestUnknownByDigest(V2Handlers.requireName(state, false), V2Handlers.requireDigest(state));
    }
}

