/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerManifestLayer;
import org.sonatype.nexus.repository.docker.internal.DockerV1Routes;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2FailureResult;
import org.sonatype.nexus.repository.proxy.BypassHttpErrorException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Status;

public class DockerFacetUtils {
    public static final String HUB_URL = "https://index.docker.io/";
    public static final String P_ATTRIBUTES = "attributes";
    public static final String CONFIG_KEY = "dockerProxy";
    private static final Pattern VALID_TAG = Pattern.compile("^[\\w][\\w.-]{0,127}$");
    public static final HashAlgorithm DOCKER_DIGEST_ALGORITHM = HashAlgorithm.SHA256;
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Collections.unmodifiableList(Lists.newArrayList((Object[])new HashAlgorithm[]{DOCKER_DIGEST_ALGORITHM, HashAlgorithm.SHA1}));
    public static final TypeReference<Map<String, Object>> JSON_AS_MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<Map<String, String>> V1_TAG_TYPE_REF = new TypeReference<Map<String, String>>(){};
    public static final TypeReference<List<String>> V1_IMAGE_ANCESTRY_TYPE_REF = new TypeReference<List<String>>(){};
    public static final TypeReference<List<Map<String, Object>>> V1_IMAGE_INDEX_TYPE_REF = new TypeReference<List<Map<String, Object>>>(){};
    public static final TypeReference<List<DockerManifestLayer>> DOCKER_LAYERS_TYPE_REF = new TypeReference<List<DockerManifestLayer>>(){};
    public static final ObjectMapper mapper = new ObjectMapper();
    public static final String V2_BLOBS_PREFIX = "v2/-/blobs/";
    public static final String V2_BLOBS_PREFIX_PATH = String.format("/%s", "v2/-/blobs/");
    public static final String DIGEST_MISMATCH = "digest mismatch";
    public static final String X_DOCKER_TOKEN = "X-Docker-Token";
    public static final Set<Integer> HTTP_SUCCESSFUL_RESPONSES = Sets.newHashSet((Object[])new Integer[]{200, 304});
    private static final Logger log = LoggerFactory.getLogger(DockerFacetUtils.class);
    private static final Pattern VALID_LAYER_ID = Pattern.compile("^([a-f0-9]{16}|[a-f0-9]{64})$");

    public static Map<String, String> readTags(InputStreamSupplier tagsContent) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = tagsContent.get();){
                return (Map)mapper.readValue(in, V1_TAG_TYPE_REF);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse tags", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    public static String readLayerId(InputStreamSupplier streamSupplier) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = streamSupplier.get();){
                return DockerFacetUtils.validateLayerId((String)mapper.readValue(in, String.class));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer id", (Throwable)e);
            throw new V1Exception.InvalidJson("Invalid data");
        }
    }

    public static List<String> readAncestry(InputStreamSupplier ancestryContent) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = ancestryContent.get();){
                return (List)mapper.readValue(in, V1_IMAGE_ANCESTRY_TYPE_REF);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer ancestry", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    public static Map<String, Object> readLayerMetadata(InputStreamSupplier layerMetadataContent) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = layerMetadataContent.get();){
                return (Map)mapper.readValue(in, JSON_AS_MAP_TYPE_REF);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            log.trace("Failed to parse layer metadata", (Throwable)e);
            throw new V1Exception.InvalidJson();
        }
    }

    public static String validateLayerId(String layerId) {
        if (!VALID_LAYER_ID.matcher(layerId).matches()) {
            throw new V1Exception.InvalidImageId();
        }
        return layerId;
    }

    public static void validateContentDigest(InputStream content, DockerDigest digest) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)digest);
        Hasher hasher = DOCKER_DIGEST_ALGORITHM.function().newHasher();
        OutputStream output = Funnels.asOutputStream((PrimitiveSink)hasher);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = content;){
            ByteStreams.copy((InputStream)in, (OutputStream)output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!digest.hash().equals(hasher.hash().toString())) {
            throw new V2Exception.DigestInvalid(DIGEST_MISMATCH);
        }
    }

    public static String v1layerMetadataName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/json";
    }

    public static String v1layerContentName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/layer";
    }

    public static String v1layerAncestryName(String layerId) {
        return String.valueOf(DockerV1Routes.V1_IMAGES) + "/" + layerId + "/ancestry";
    }

    public static String v1imagesIndexName(String name) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/images";
    }

    public static String v1tagsName(String name) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/tags";
    }

    public static String v1tagName(String name, String tag) {
        return String.valueOf(DockerV1Routes.V1_REPOSITORIES) + "/" + name + "/tags/" + tag;
    }

    public static String blobName(DockerDigest digest) {
        Preconditions.checkNotNull((Object)digest);
        return V2_BLOBS_PREFIX + digest;
    }

    public static String blobAssetRequest(DockerDigest digest, String name) {
        Preconditions.checkNotNull((Object)digest);
        Preconditions.checkNotNull((Object)name);
        return "/v2/" + name + "/blobs/" + digest;
    }

    public static String manifestName(String name, DockerDigest digest) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)digest);
        return "v2/" + name + "/manifests/" + digest;
    }

    public static String tagName(String name, String tag) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)tag);
        return "v2/" + name + "/manifests/" + tag;
    }

    public static String tagListName(String name) {
        Preconditions.checkNotNull((Object)name);
        return "v2/" + name + "/tags/list";
    }

    public static String catalogName() {
        return "v2/_catalog";
    }

    public static URI getHubUri() {
        return URI.create(HUB_URL);
    }

    public static HttpResponse executeForeignLayerRequest(List<String> foreignLayerUrls, String digest, HttpClient client, HttpContext httpContext, HttpRequestBase request) throws IOException {
        if (foreignLayerUrls.isEmpty()) {
            HttpResponse response = client.execute((HttpUriRequest)request, httpContext);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 400) {
                log.warn("Layer with digest: {} has been marked as a foreign layer, but has no saved URLs; check whitelist config.", (Object)digest);
                if (statusCode == 404) {
                    response.setStatusCode(403);
                }
            }
            return response;
        }
        log.debug("Found foreign layer with URLs: {} for digest: {}", foreignLayerUrls, (Object)digest);
        for (String url : foreignLayerUrls) {
            try {
                request.setURI(new URI(url));
                HttpResponse response = client.execute((HttpUriRequest)request, httpContext);
                if (HTTP_SUCCESSFUL_RESPONSES.contains(response.getStatusLine().getStatusCode())) {
                    return response;
                }
                log.debug("Unsuccessful response for foreign layer with digest: {} from URL: {} : {}", new Object[]{digest, url, response});
            }
            catch (Exception e) {
                log.debug("Unable to retrieve foreign layer with digest: {} from URL: {}", new Object[]{digest, url, e});
            }
        }
        log.warn("Unable to retrieve foreign layer for digest: {} from any of its referenced URLs", (Object)digest);
        return client.execute((HttpUriRequest)request, httpContext);
    }

    public static V1Exception getReason(AssetKind assetKind) {
        switch (assetKind) {
            case IMAGES: {
                return new V1Exception.ImagesNotFound();
            }
            case TAGS: {
                return new V1Exception.RepositoryNotFound();
            }
            case TAG: {
                return new V1Exception.TagNotFound();
            }
            case LAYER_METADATA: 
            case LAYER_CONTENT: 
            case LAYER_ANCESTRY: {
                return new V1Exception.ImageNotFound();
            }
            case SEARCH: {
                return new V1Exception.SearchEndpointNotFound();
            }
        }
        throw new IllegalStateException("No case for assetKind: " + assetKind.toString());
    }

    public static void setAttributeFromHeader(Context context, HttpResponse response, String key) {
        Header tokenHeader = response.getFirstHeader(key);
        if (tokenHeader != null) {
            context.getAttributes().set(key, (Object)tokenHeader.getValue());
        }
    }

    public static void checkResponseStatus(Context context, AssetKind assetKind, HttpRequestBase request, HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (AssetKind.IMAGES == assetKind && statusCode == 200) {
            DockerFacetUtils.setAttributeFromHeader(context, response, X_DOCKER_TOKEN);
        }
        if (AssetKind.Version.V1.equals((Object)assetKind.getVersion()) && statusCode == 404) {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            V1Exception reason = DockerFacetUtils.getReason(assetKind);
            throw new V1Exception.InvalidResponseFromRemote(reason, request.getURI().getHost(), request.getURI().getPath());
        }
        if (AssetKind.Version.V2.equals((Object)assetKind.getVersion()) && statusCode == 401) {
            try {
                ArrayListMultimap headers = ArrayListMultimap.create();
                Header[] headerArray = response.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    headers.put((Object)header.getName(), (Object)header.getValue());
                    ++n2;
                }
                throw new BypassHttpErrorException(404, response.getStatusLine().getReasonPhrase(), (ListMultimap)headers);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly((HttpResponse)response);
                throw throwable;
            }
        }
        if (AssetKind.Version.V2.equals((Object)assetKind.getVersion()) && statusCode >= 400) {
            try {
                if (response.getEntity() != null) {
                    try {
                        V2FailureResult v2Failure = (V2FailureResult)mapper.readValue(response.getEntity().getContent(), V2FailureResult.class);
                        if (v2Failure != null && !v2Failure.getErrors().isEmpty()) {
                            throw new V2Exception(statusCode, v2Failure.getErrors().get(0));
                        }
                    }
                    catch (JsonParseException e) {
                        log.warn("Could not parse error response {}", (Object)e.getMessage());
                    }
                }
                throw new V2Exception(statusCode, V2Error.mapFromStatus(Status.failure((int)statusCode)));
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly((HttpResponse)response);
                throw throwable;
            }
        }
    }

    public static String buildUrl(String realm, String service, String scope, Repository repository) throws AuthenticationException {
        try {
            URIBuilder uriBuilder = new URIBuilder(realm);
            if (!service.isEmpty()) {
                uriBuilder.addParameter("service", service);
            }
            if (!scope.isEmpty()) {
                uriBuilder.addParameter("scope", scope);
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException(String.format("Could not build url to fetch docker token from %s for repository %s", realm, repository), (Throwable)e);
        }
    }

    public static String readToken(HttpResponse response, String realm) throws IOException, AuthenticationException {
        Map parsed = (Map)mapper.readValue(response.getEntity().getContent(), V1_TAG_TYPE_REF);
        String token = (String)parsed.get("token");
        if (Objects.nonNull(token)) {
            return token;
        }
        token = (String)parsed.get("access_token");
        if (Objects.nonNull(token)) {
            return token;
        }
        throw new AuthenticationException(String.format("Could not retrieve bearer token from %s. Returned token is not set", realm));
    }

    public static HttpResponse executeOK(String from, HttpClient client, HttpGet request) throws IOException, AuthenticationException {
        log.debug("Fetching: {}", (Object)request);
        HttpResponse response = client.execute((HttpUriRequest)request);
        log.debug("Response: {}", (Object)response);
        StatusLine status = response.getStatusLine();
        log.debug("Status: {}", (Object)status);
        if (status.getStatusCode() != 200) {
            HttpClientUtils.closeQuietly((HttpResponse)response);
            throw new AuthenticationException(String.format("Could not retrieve token from %s. Status code: %s", from, status.getStatusCode()));
        }
        return response;
    }

    public static boolean isTrue(Boolean check) {
        return Boolean.TRUE.equals(check);
    }

    @Nullable
    public static HttpResponse maybeExecuteConditionalHead(HttpRequestBase request, HttpClient client, HttpContext tokenContext) throws IOException {
        if (request.getLastHeader("If-Modified-Since") != null || request.getLastHeader("If-None-Match") != null) {
            HttpHead headRequest = new HttpHead(request.getURI());
            headRequest.setHeaders(request.getAllHeaders());
            HttpResponse response = client.execute((HttpUriRequest)headRequest, tokenContext);
            return response.getStatusLine().getStatusCode() == 304 ? response : null;
        }
        return null;
    }

    private DockerFacetUtils() {
    }

    public static Content createDockerManifestContent(Content content, String contentType) {
        return new DockerManifestContent(content, contentType);
    }

    public static List<Map<String, Object>> readImagesIndex(InputStreamSupplier imagesIndexContent) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream in = imagesIndexContent.get();){
                return (List)mapper.readValue(in, V1_IMAGE_INDEX_TYPE_REF);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new V1Exception.InvalidJson();
        }
    }

    public static void validateTagName(String tag) {
        if (!VALID_TAG.matcher(tag).matches()) {
            throw new V1Exception.InvalidTagName();
        }
    }

    static class DockerManifestContent
    extends Content {
        private final String contentType;

        public DockerManifestContent(Content wrapped, String contentType) {
            super((Payload)wrapped, wrapped.getAttributes());
            this.contentType = contentType;
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }
    }
}

