/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class DockerDigest {
    private final String algorithm;
    private final String hash;

    public DockerDigest(String algorithm, String hash) {
        this.algorithm = (String)Preconditions.checkNotNull((Object)algorithm);
        this.hash = (String)Preconditions.checkNotNull((Object)hash);
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String hash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerDigest)) {
            return false;
        }
        DockerDigest that = (DockerDigest)o;
        if (!this.hash().equals(that.hash())) {
            return false;
        }
        return this.algorithm().equals(that.algorithm());
    }

    public int hashCode() {
        int result = this.algorithm().hashCode();
        result = 31 * result + this.hash().hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(this.algorithm) + ":" + this.hash;
    }

    public static DockerDigest parse(String string) {
        Preconditions.checkNotNull((Object)string);
        String[] parts = string.split(":");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Digest must be formed as 'alg:hex': %s", (Object)string);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parts[0]) ? 1 : 0) != 0, (String)"alg part empty: '%s'", (Object)string);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parts[1]) ? 1 : 0) != 0, (String)"hex part empty: '%s'", (Object)string);
        return new DockerDigest(parts[0], parts[1]);
    }
}

