/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import java.io.IOException;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.HttpConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;

public class DockerConnectorConfiguration
implements ConnectorConfiguration {
    private final String nexusContextPath;
    private final String repositoryName;
    private final HttpScheme scheme;
    private final int port;

    public DockerConnectorConfiguration(String nexusContextPath, String repositoryName, HttpScheme scheme, int port) {
        this.nexusContextPath = nexusContextPath;
        this.repositoryName = repositoryName;
        this.scheme = scheme;
        this.port = port;
    }

    public HttpScheme getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public HttpConfiguration customize(HttpConfiguration configuration) {
        HttpConfiguration httpConfig = new HttpConfiguration(configuration);
        httpConfig.addCustomizer((connector, channelConfig, request) -> {
            HttpURI uri = request.getHttpURI();
            String version = null;
            if (uri.getPath().startsWith("/v1")) {
                version = "/v1";
            } else if (uri.getPath().startsWith("/v2")) {
                version = "/v2";
            }
            if (version != null) {
                request.setHttpURI(new HttpURI(uri.toString().replaceFirst(version, String.valueOf(this.nexusContextPath) + "repository/" + this.repositoryName + version)));
                request.setMetaData(request.getMetaData());
            } else {
                try {
                    request.getResponse().sendError(400, "Not a Docker request");
                    request.setHandled(true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return httpConfig;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName=" + this.repositoryName + ", scheme=" + this.scheme + ", port=" + this.port + '}';
    }
}

