/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;

public enum AssetKind {
    IMAGES(Version.V1, CacheControllerHolder.METADATA),
    TAGS(Version.V1, CacheControllerHolder.METADATA),
    TAG(Version.V1, CacheControllerHolder.METADATA),
    LAYER_METADATA(Version.V1, CacheControllerHolder.METADATA),
    LAYER_CONTENT(Version.V1, CacheControllerHolder.CONTENT),
    LAYER_ANCESTRY(Version.V1, CacheControllerHolder.METADATA),
    SEARCH(Version.V1, CacheControllerHolder.METADATA),
    MANIFEST(Version.V2, CacheControllerHolder.METADATA),
    BLOB(Version.V2, CacheControllerHolder.CONTENT),
    TAG_LIST(Version.V2, CacheControllerHolder.METADATA),
    CATALOG(Version.V2, CacheControllerHolder.METADATA);

    private final Version version;
    private final CacheControllerHolder.CacheType cacheType;

    private AssetKind(Version version, CacheControllerHolder.CacheType cacheType) {
        this.version = (Version)((Object)Preconditions.checkNotNull((Object)((Object)version)));
        this.cacheType = (CacheControllerHolder.CacheType)Preconditions.checkNotNull((Object)cacheType);
    }

    public Version getVersion() {
        return this.version;
    }

    @Nonnull
    public CacheControllerHolder.CacheType getCacheType() {
        return this.cacheType;
    }

    public static enum Version {
        V1,
        V2;

    }
}

