/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.docker.api.model.DockerHostedRepositoryApiRequest;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeatureControlService;
import org.sonatype.nexus.repository.rest.api.HostedRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.HostedRepositoryApiRequest;

@Named
public class DockerHostedRepositoryApiRequestToConfigurationConverter
extends HostedRepositoryApiRequestToConfigurationConverter<DockerHostedRepositoryApiRequest> {
    private final boolean subdomainEnabled;

    @Inject
    public DockerHostedRepositoryApiRequestToConfigurationConverter(DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService) {
        this.subdomainEnabled = dockerSubdomainFeatureControlService.isFeatureAllowed();
    }

    public Configuration convert(DockerHostedRepositoryApiRequest request) {
        Configuration configuration = super.convert((HostedRepositoryApiRequest)request);
        configuration.attributes("docker").set("v1Enabled", (Object)request.getDocker().getV1Enabled());
        configuration.attributes("docker").set("forceBasicAuth", (Object)request.getDocker().getForceBasicAuth());
        configuration.attributes("docker").set("httpPort", (Object)request.getDocker().getHttpPort());
        configuration.attributes("docker").set("httpsPort", (Object)request.getDocker().getHttpsPort());
        if (this.subdomainEnabled) {
            configuration.attributes("docker").set("subdomain", (Object)request.getDocker().getSubdomain());
        }
        return configuration;
    }
}

