/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.validation.constraint.PortNumber;

public class DockerAttributes {
    public static final String V1_ENABLED_ATTRIBUTE = "v1Enabled";
    public static final String FORCE_BASIC_AUTH_ATTRIBUTE = "forceBasicAuth";
    public static final String HTTP_PORT_ATTRIBUTE = "httpPort";
    public static final String HTTPS_PORT_ATTRIBUTE = "httpsPort";
    public static final String SUBDOMAIN_ATTRIBUTE = "subdomain";
    @ApiModelProperty(value="Whether to allow clients to use the V1 API to interact with this repository", example="false")
    @NotNull
    protected Boolean v1Enabled;
    @ApiModelProperty(value="Whether to force authentication (Docker Bearer Token Realm required if false)", example="true")
    @NotNull
    protected Boolean forceBasicAuth;
    @ApiModelProperty(value="Create an HTTP connector at specified port", example="8082")
    @PortNumber
    protected Integer httpPort;
    @ApiModelProperty(value="Create an HTTPS connector at specified port", example="8083")
    @PortNumber
    protected Integer httpsPort;
    @ApiModelProperty(value="Allows to use subdomain", example="docker-a")
    @Nullable
    protected String subdomain;

    @JsonCreator
    public DockerAttributes(@JsonProperty(value="v1Enabled") Boolean v1Enabled, @JsonProperty(value="forceBasicAuth") Boolean forceBasicAuth, @JsonProperty(value="httpPort") Integer httpPort, @JsonProperty(value="httpsPort") Integer httpsPort, @JsonProperty(value="subdomain") String subdomain) {
        this.v1Enabled = v1Enabled;
        this.forceBasicAuth = forceBasicAuth;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.subdomain = subdomain;
    }

    public Boolean getV1Enabled() {
        return this.v1Enabled;
    }

    public Boolean getForceBasicAuth() {
        return this.forceBasicAuth;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public String getSubdomain() {
        return this.subdomain;
    }
}

