/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.api.DockerAttributes;
import org.sonatype.nexus.repository.docker.api.DockerGroupApiRepository;
import org.sonatype.nexus.repository.docker.api.DockerHostedApiRepository;
import org.sonatype.nexus.repository.docker.api.DockerProxyApiRepository;
import org.sonatype.nexus.repository.docker.api.DockerProxyAttributes;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeatureControlService;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="docker")
public class DockerApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    private final boolean subdomainEnabled;

    @Inject
    public DockerApiRepositoryAdapter(DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService, RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
        this.subdomainEnabled = dockerSubdomainFeatureControlService.isFeatureAllowed();
    }

    public AbstractApiRepository adapt(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String name = repository.getName();
        String url = repository.getUrl();
        switch (repository.getType().toString()) {
            case "group": {
                return new DockerGroupApiRepository(name, url, online, this.getStorageAttributes(repository), this.getGroupAttributes(repository), this.createDockerAttributes(repository));
            }
            case "hosted": {
                return new DockerHostedApiRepository(name, url, online, this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createDockerAttributes(repository), this.getComponentAttributes(repository));
            }
            case "proxy": {
                return new DockerProxyApiRepository(name, url, online, (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createDockerAttributes(repository), this.createDockerProxyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.getReplicationAttributes(repository));
            }
        }
        return null;
    }

    private DockerAttributes createDockerAttributes(Repository repository) {
        NestedAttributesMap dockerAttributes = repository.getConfiguration().attributes("docker");
        Boolean v1Enabled = (Boolean)dockerAttributes.get("v1Enabled", Boolean.class);
        Boolean forceBasicAuth = (Boolean)dockerAttributes.get("forceBasicAuth", Boolean.class, (Object)Boolean.TRUE);
        Integer httpPort = DockerApiRepositoryAdapter.toInt((Number)((Number)dockerAttributes.get("httpPort", Number.class)));
        Integer httpsPort = DockerApiRepositoryAdapter.toInt((Number)((Number)dockerAttributes.get("httpsPort", Number.class)));
        String subdomain = null;
        if (this.subdomainEnabled) {
            subdomain = (String)dockerAttributes.get("subdomain", String.class);
        }
        return new DockerAttributes(v1Enabled, forceBasicAuth, httpPort, httpsPort, subdomain);
    }

    private DockerProxyAttributes createDockerProxyAttributes(Repository repository) {
        NestedAttributesMap dockerAttributes = repository.getConfiguration().attributes("dockerProxy");
        String indexType = (String)dockerAttributes.get("indexType", String.class);
        String indexUrl = (String)dockerAttributes.get("indexUrl", String.class);
        return new DockerProxyAttributes(indexType, indexUrl);
    }
}

