/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named(value="docker")
@Singleton
public class DockerUploadHandler
extends UploadHandlerSupport {
    private static final String LIBRARY_NAMESPACE_PREFIX = "library/";
    private static final TokenParser v1ImageMetadataPathParser = new TokenParser("{prefix:/?}v1/images/{layerId}/json");
    private static final TokenParser v1ImageContentPathParser = new TokenParser("{prefix:/?}v1/images/{layerId}/layer");
    private static final TokenParser v1TagPathParser = new TokenParser("{prefix:/?}v1/repositories/{name:.+}/tags/{tag}");
    private static final TokenParser v1ImagesIndexPathParser = new TokenParser("{prefix:/?}v1/repositories/{name:.+}/images");
    private static final TokenParser v2ManifestPathParser = new TokenParser("{prefix:/?}v2/{name:.+}/manifests/{tag}");
    private static final TokenParser exportManifestPathParser = new TokenParser("{prefix:/?}{name:.+}/{tag}/manifest.json");
    private static final TokenParser exportManifestListPathParser = new TokenParser("{prefix:/?}{name:.+}/{tag}/list.manifest.json");
    private static final TokenParser exportBlobPathParser = new TokenParser("{name:.+}/{tag}/{alg}__{hash:[^/\\.]+}");
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final ObjectMapper mapper = new ObjectMapper();
    private UploadDefinition definition;

    @Inject
    public DockerUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)path);
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration);
        boolean hardLinkingEnabled = configuration.isHardLinkingEnabled();
        Repository repository = configuration.getRepository();
        File content = configuration.getFile();
        String assetName = configuration.getAssetName();
        this.ensurePermitted(repository.getName(), "docker", assetName, Collections.emptyMap());
        DockerHostedFacet dockerHostedFacet = (DockerHostedFacet)repository.facet(DockerHostedFacet.class);
        Content result = null;
        assetName = DockerUploadHandler.fixDockerHubLibraryPath(assetName);
        switch (this.importAssetType(assetName)) {
            case V1_LAYER_METADATA: {
                result = this.handleV1LayerMetadata(dockerHostedFacet, assetName, content);
                break;
            }
            case V1_LAYER_CONTENT: {
                result = this.handleV1LayerContent(dockerHostedFacet, assetName, content, hardLinkingEnabled);
                break;
            }
            case V1_IMAGES_INDEX: {
                result = this.handleV1ImagesIndex(dockerHostedFacet, assetName, content);
                break;
            }
            case V1_TAG: {
                result = this.handleV1Tags(dockerHostedFacet, assetName, content);
                break;
            }
            case V2_BLOB: {
                result = this.handleV2Blob(dockerHostedFacet, assetName, content, hardLinkingEnabled);
                break;
            }
            case V2_MANIFEST: {
                result = this.handleV2Manifest(dockerHostedFacet, assetName, content);
                break;
            }
            case EXPORT_MANIFEST: {
                result = this.handleExportManifest(dockerHostedFacet, assetName, content);
                break;
            }
            case EXPORT_MANIFEST_LIST: {
                result = this.handleExportManifestList(dockerHostedFacet, assetName, content);
                break;
            }
            case EXPORT_BLOB: {
                result = this.handleExportBlob(dockerHostedFacet, assetName, content, hardLinkingEnabled);
                break;
            }
            default: {
                this.log.info("can't determine asset type of {}, not importing", (Object)content);
            }
        }
        return result;
    }

    private Content handleV1LayerMetadata(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = Objects.requireNonNull(v1ImageMetadataPathParser.parse(path));
        Throwable throwable = null;
        Object var6_7 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/json");){
            return dockerHostedFacet.importV1LayerMetadata((String)parsedPath.get("layerId"), (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleV1LayerContent(DockerHostedFacet dockerHostedFacet, String path, File content, boolean hardLinkingEnabled) throws IOException {
        Map parsedPath = Objects.requireNonNull(v1ImageContentPathParser.parse(path));
        Throwable throwable = null;
        Object var7_8 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/octet-stream");){
            String layerId = (String)parsedPath.get("layerId");
            if (hardLinkingEnabled) {
                dockerHostedFacet.importV1LayerContent(layerId, (Payload)payload, content);
            }
            return dockerHostedFacet.importV1LayerContent(layerId, (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleV1ImagesIndex(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = Objects.requireNonNull(v1ImagesIndexPathParser.parse(path));
        Throwable throwable = null;
        Object var6_7 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/json");){
            String name = (String)parsedPath.get("name");
            return dockerHostedFacet.importV1ImagesIndex(name, (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleV1Tags(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = Objects.requireNonNull(v1TagPathParser.parse(path));
        Throwable throwable = null;
        Object var6_7 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/json");){
            String name = (String)parsedPath.get("name");
            return dockerHostedFacet.importV1Tag(name, (String)parsedPath.get("tag"), (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleV2Blob(DockerHostedFacet dockerHostedFacet, String path, File content, boolean hardLinkingEnabled) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/vnd.docker.image.rootfs.diff.tar.gzip");){
            String uuid = dockerHostedFacet.beginBlobUpload("-");
            DockerDigest digest = this.digestFromPath(path);
            UploadCompletion uploadCompletion = hardLinkingEnabled ? dockerHostedFacet.completeBlobUpload(content, "-", uuid, digest, (Payload)payload) : dockerHostedFacet.completeBlobUpload("-", uuid, digest, Optional.empty(), (Payload)payload);
            return uploadCompletion.getContent();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content handleV2Manifest(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = v2ManifestPathParser.parse(path);
        if (parsedPath != null && parsedPath.containsKey("name") && parsedPath.containsKey("tag")) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/vnd.docker.distribution.manifest.v2+json");){
                String tag = (String)parsedPath.get("tag");
                String name = (String)parsedPath.get("name");
                if (tag.contains(":")) {
                    return dockerHostedFacet.importManifestByDigest(name, this.digestFromPath(path), (Payload)payload);
                }
                return dockerHostedFacet.importManifestByTag(name, tag, (Payload)payload);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private Content handleExportManifest(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = exportManifestPathParser.parse(path);
        if (parsedPath != null && parsedPath.containsKey("name") && parsedPath.containsKey("tag")) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/vnd.docker.distribution.manifest.v2+json");){
                String tag = (String)parsedPath.get("tag");
                String name = (String)parsedPath.get("name");
                if (tag.contains("__")) {
                    return dockerHostedFacet.importManifestByDigest(name, this.digestFromExportTag(tag), (Payload)payload);
                }
                return dockerHostedFacet.importManifestByTag(name, tag, (Payload)payload);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private Content handleExportManifestList(DockerHostedFacet dockerHostedFacet, String path, File content) throws IOException {
        Map parsedPath = exportManifestListPathParser.parse(path);
        if (parsedPath != null && parsedPath.containsKey("name") && parsedPath.containsKey("tag")) {
            String tag = (String)parsedPath.get("tag");
            String name = (String)parsedPath.get("name");
            this.log.debug("found a manifest list at {}, parsing to find actual manifests", (Object)content);
            ExportManifestList exportManifestList = (ExportManifestList)this.mapper.readValue(content, ExportManifestList.class);
            for (ExportManifestListEntry entry : exportManifestList.manifests) {
                String escapedName = entry.digest.replace(":", "__");
                File manifestContent = new File(new File(content.getParentFile().getParentFile(), escapedName), "manifest.json");
                this.log.debug("looking for a manifest file at {}", (Object)manifestContent);
                if (!manifestContent.exists()) continue;
                this.log.debug("found a manifest file at {}, importing to {} by tag {}", new Object[]{manifestContent, name, tag});
                Throwable throwable = null;
                Object var13_14 = null;
                try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(manifestContent), manifestContent.length(), "application/vnd.docker.distribution.manifest.v2+json");){
                    return dockerHostedFacet.importManifestByTag(name, tag, (Payload)payload);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return null;
        }
        return null;
    }

    private Content handleExportBlob(DockerHostedFacet dockerHostedFacet, String path, File content, boolean hardLinkingEnabled) throws IOException {
        Map parsedPath = Objects.requireNonNull(exportBlobPathParser.parse(path));
        Throwable throwable = null;
        Object var7_8 = null;
        try (StreamPayload payload = new StreamPayload(() -> new FileInputStream(content), content.length(), "application/vnd.docker.image.rootfs.diff.tar.gzip");){
            String uuid = dockerHostedFacet.beginBlobUpload("-");
            DockerDigest digest = new DockerDigest((String)parsedPath.get("alg"), (String)parsedPath.get("hash"));
            UploadCompletion uploadCompletion = hardLinkingEnabled ? dockerHostedFacet.completeBlobUpload(content, "-", uuid, digest, (Payload)payload) : dockerHostedFacet.completeBlobUpload("-", uuid, digest, Optional.empty(), (Payload)payload);
            return uploadCompletion.getContent();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    ImportAssetType importAssetType(String path) {
        if (path.startsWith("v2/") || path.startsWith("/v2/")) {
            if (path.contains("/-/blobs/")) {
                return ImportAssetType.V2_BLOB;
            }
            return ImportAssetType.V2_MANIFEST;
        }
        if (path.startsWith("v1/") || path.startsWith("/v1/")) {
            if (v1ImageMetadataPathParser.parse(path) != null) {
                return ImportAssetType.V1_LAYER_METADATA;
            }
            if (v1ImageContentPathParser.parse(path) != null) {
                return ImportAssetType.V1_LAYER_CONTENT;
            }
            if (v1ImagesIndexPathParser.parse(path) != null) {
                return ImportAssetType.V1_IMAGES_INDEX;
            }
            if (v1TagPathParser.parse(path) != null) {
                return ImportAssetType.V1_TAG;
            }
        } else {
            if (exportManifestPathParser.parse(path) != null) {
                return ImportAssetType.EXPORT_MANIFEST;
            }
            if (exportManifestListPathParser.parse(path) != null) {
                return ImportAssetType.EXPORT_MANIFEST_LIST;
            }
            if (exportBlobPathParser.parse(path) != null) {
                return ImportAssetType.EXPORT_BLOB;
            }
        }
        return ImportAssetType.UNKNOWN;
    }

    @VisibleForTesting
    DockerDigest digestFromPath(String path) {
        int lastSeparator = path.lastIndexOf(47);
        String filename = lastSeparator == -1 ? path : path.substring(lastSeparator + 1);
        return DockerDigest.parse(filename);
    }

    @VisibleForTesting
    DockerDigest digestFromExportTag(String tag) {
        return DockerDigest.parse(tag.replace("__", ":"));
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("docker", false);
        }
        return this.definition;
    }

    public boolean supportsUiUpload() {
        return false;
    }

    public boolean supportsExportImport() {
        return true;
    }

    private static String fixDockerHubLibraryPath(String path) {
        if (path.contains(LIBRARY_NAMESPACE_PREFIX)) {
            return path.replaceFirst(LIBRARY_NAMESPACE_PREFIX, "");
        }
        return path;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ExportManifestList {
        public List<ExportManifestListEntry> manifests;

        private ExportManifestList() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ExportManifestListEntry {
        public String digest;

        private ExportManifestListEntry() {
        }
    }

    static enum ImportAssetType {
        UNKNOWN,
        V1_LAYER_METADATA,
        V1_LAYER_CONTENT,
        V1_IMAGES_INDEX,
        V1_TAG,
        V2_BLOB,
        V2_MANIFEST,
        EXPORT_BLOB,
        EXPORT_MANIFEST,
        EXPORT_MANIFEST_LIST;

    }
}

