/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.rest;

import com.sonatype.nexus.repository.golang.rest.model.GolangProxyRepositoryApiRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.nexus.repository.rest.api.AbstractProxyRepositoriesApiResource;
import org.sonatype.nexus.repository.rest.api.model.AbstractRepositoryApiRequest;
import org.sonatype.nexus.validation.Validate;

@Api(value="Repository Management")
public abstract class GolangProxyRepositoriesApiResource
extends AbstractProxyRepositoriesApiResource<GolangProxyRepositoryApiRequest> {
    @ApiOperation(value="Create a Go proxy repository")
    @ApiResponses(value={@ApiResponse(code=201, message="Repository created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=405, message="Feature is disabled in High Availability")})
    @POST
    @RequiresAuthentication
    @Validate
    public Response createRepository(GolangProxyRepositoryApiRequest request) {
        return super.createRepository((AbstractRepositoryApiRequest)request);
    }

    @ApiOperation(value="Update a Go proxy repository")
    @ApiResponses(value={@ApiResponse(code=204, message="Repository updated"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Repository not found")})
    @PUT
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    public Response updateRepository(GolangProxyRepositoryApiRequest request, @ApiParam(value="Name of the repository to update") @PathParam(value="repositoryName") String repositoryName) {
        return super.updateRepository((AbstractRepositoryApiRequest)request, repositoryName);
    }

    public boolean isApiEnabled() {
        return this.highAvailabilitySupportChecker.isSupported("go");
    }
}

