/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.orient.internal.hosted;

import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.util.GolangPathUtils;
import com.sonatype.nexus.repository.golang.orient.internal.hosted.OrientGolangHostedFacet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class OrientHostedHandlers
extends ComponentSupport {
    final Handler get = context -> {
        Content content;
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        switch (assetKind) {
            case INFO: {
                content = this.getInfo(context);
                break;
            }
            case MODULE: {
                content = this.getModule(context);
                break;
            }
            case PACKAGE: {
                content = this.getPackage(context);
                break;
            }
            case LIST: {
                content = this.getList(context);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown assetKind %s", assetKind.name()));
            }
        }
        return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
    };
    final Handler upload = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(state);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ((OrientGolangHostedFacet)context.getRepository().facet(OrientGolangHostedFacet.class)).upload(path, golangAttributes, context.getRequest().getPayload(), assetKind);
        return HttpResponses.created();
    };

    private Content getList(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String module = GolangPathUtils.module(state);
        return ((OrientGolangHostedFacet)context.getRepository().facet(OrientGolangHostedFacet.class)).getList(module);
    }

    private Content getPackage(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        return ((OrientGolangHostedFacet)context.getRepository().facet(OrientGolangHostedFacet.class)).getPackage(path);
    }

    private Content getModule(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        return ((OrientGolangHostedFacet)context.getRepository().facet(OrientGolangHostedFacet.class)).getMod(path);
    }

    private Content getInfo(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(state);
        return ((OrientGolangHostedFacet)context.getRepository().facet(OrientGolangHostedFacet.class)).getInfo(path, golangAttributes);
    }
}

