/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.internal.util;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class GolangPathUtils {
    private GolangPathUtils() {
    }

    public static String module(TokenMatcher.State state) {
        return GolangPathUtils.match(state, "module");
    }

    public static String version(TokenMatcher.State state) {
        return GolangPathUtils.match(state, "version");
    }

    public static String extension(TokenMatcher.State state) {
        return GolangPathUtils.match(state, "extension");
    }

    public static String assetPath(TokenMatcher.State state) {
        String module = GolangPathUtils.module(state);
        String version = GolangPathUtils.version(state);
        String extension = GolangPathUtils.extension(state);
        return String.format("%s/@v/%s.%s", module, version, extension);
    }

    public static String listPath(TokenMatcher.State state) {
        String module = GolangPathUtils.module(state);
        return String.format("%s/@v/list", module);
    }

    public static String latestPath(TokenMatcher.State state) {
        String module = GolangPathUtils.module(state);
        return String.format("%s/@latest", module);
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static GolangAttributes getAttributesFromMatcherState(TokenMatcher.State state) {
        GolangAttributes golangAttributes = new GolangAttributes();
        golangAttributes.setModule(GolangPathUtils.module(state));
        golangAttributes.setVersion(GolangPathUtils.version(state));
        return golangAttributes;
    }
}

