/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.input.NullInputStream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Payload;

public class CompressedContentExtractor
extends ComponentSupport {
    @Nullable
    public InputStream extractFile(InputStream projectAsStream, String fileName) {
        return this.extract(projectAsStream, fileName, this::fetchFileAsStream);
    }

    public boolean fileExists(Payload payload, String path, String fileName) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream projectAsStream = payload.openInputStream();){
                boolean bl = this.extract(projectAsStream, fileName, z -> new NullInputStream(-1L)) != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to open content {}", (Object)path, (Object)e);
            return false;
        }
    }

    private ByteArrayInputStream fetchFileAsStream(ZipInputStream zipInputStream) {
        try {
            ByteArrayOutputStream outputStream = this.extractEntry(zipInputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException e) {
            this.log.warn("Unable to uncompress zip", (Throwable)e);
            return null;
        }
    }

    private ByteArrayOutputStream extractEntry(ZipInputStream zipInputStream) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((read = zipInputStream.read(bytes)) >= 0) {
            outputStream.write(bytes, 0, read);
        }
        return outputStream;
    }

    /*
     * Unable to fully structure code
     */
    private InputStream extract(InputStream projectAsStream, String fileName, Function<ZipInputStream, InputStream> method) {
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                zipInputStream = new ZipInputStream(projectAsStream);
                try {
                    nextEntry = zipInputStream.getNextEntry();
                    while (true) {
                        if (nextEntry.getName().endsWith(fileName)) {
                            return method.apply(zipInputStream);
                        }
                        zipInputStream.closeEntry();
                        nextEntry = zipInputStream.getNextEntry();
                        return nextEntry;
                    }
                }
                finally {
                    if (nextEntry != null) ** continue;
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                } else if (var4_4 != var5_8) {
                    var4_4.addSuppressed(var5_8);
                }
                throw var4_4;
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to uncompress zip", (Throwable)e);
        }
        return null;
    }
}

