/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.datastore.internal.proxy;

import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.datastore.GoContentFacet;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.util.GolangPathUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
public class GoProxyFacet
extends ProxyFacetSupport {
    @Nullable
    protected Content getCachedContent(Context context) {
        String assetPath = this.getAssetPath(context);
        return ((GoContentFacet)this.facet(GoContentFacet.class)).getAsset(assetPath).map(FluentAsset::download).orElse(null);
    }

    protected Content store(Context context, Content content) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = GolangPathUtils.matcherState(context);
        String assetPath = this.getAssetPath(context);
        switch (assetKind) {
            case PACKAGE: 
            case INFO: 
            case MODULE: {
                GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(matcherState);
                return ((GoContentFacet)this.facet(GoContentFacet.class)).saveComponentAndAsset(assetPath, (Payload)content, assetKind, golangAttributes).markAsCached((Payload)content).download();
            }
            case LIST: 
            case LATEST: {
                return ((GoContentFacet)this.facet(GoContentFacet.class)).saveAsset(assetPath, (Payload)content, assetKind).markAsCached((Payload)content).download();
            }
        }
        throw new IllegalStateException(String.format("Could not store content. Received an unsupported AssetKind of type: %s on the repository %s", assetKind.name(), this.getRepository().getName()));
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
        String assetPath = this.getAssetPath(context);
        Optional<FluentAsset> fluentAssetOptional = ((GoContentFacet)this.facet(GoContentFacet.class)).getAsset(assetPath);
        if (!fluentAssetOptional.isPresent()) {
            this.log.debug("Attempting to set cache info for non-existent go asset: {} on the repository: {}", (Object)assetPath, (Object)this.getRepository().getName());
            return;
        }
        FluentAsset fluentAsset = fluentAssetOptional.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating cacheInfo of {} to {} on the repository {}", new Object[]{fluentAsset.path(), cacheInfo, this.getRepository().getName()});
        }
        fluentAsset.markAsCached(cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    private String getAssetPath(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = GolangPathUtils.matcherState(context);
        switch (assetKind) {
            case PACKAGE: 
            case INFO: 
            case MODULE: {
                return GolangPathUtils.assetPath(matcherState);
            }
            case LIST: {
                return GolangPathUtils.listPath(matcherState);
            }
            case LATEST: {
                return GolangPathUtils.latestPath(matcherState);
            }
        }
        throw new IllegalStateException(String.format("Could not get asset path. Received an unsupported AssetKind of type: %s on the repository %s", assetKind.name(), this.getRepository().getName()));
    }
}

