/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.datastore.internal.hosted;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.datastore.GoContentFacet;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.util.GolangPathUtils;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class GoHostedHandlers
extends ComponentSupport {
    final Handler get = context -> {
        Optional<Content> content;
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        switch (assetKind) {
            case INFO: {
                content = this.getInfo(context);
                break;
            }
            case PACKAGE: 
            case MODULE: {
                content = this.getPackage(context);
                break;
            }
            case LIST: {
                content = this.getList(context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported asset kind " + (Object)((Object)assetKind));
            }
        }
        return content.map(HttpResponses::ok).orElse(HttpResponses.notFound());
    };
    final Handler upload = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(state);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        Preconditions.checkArgument((AssetKind.PACKAGE == assetKind ? 1 : 0) != 0, (Object)("Unsupported asset kind " + (Object)((Object)assetKind)));
        ((GoContentFacet)context.getRepository().facet(GoContentFacet.class)).upload(path, golangAttributes, context.getRequest().getPayload());
        return HttpResponses.created();
    };

    private Optional<Content> getList(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String module = GolangPathUtils.module(state);
        return ((GoContentFacet)context.getRepository().facet(GoContentFacet.class)).getVersions(module);
    }

    private Optional<Content> getPackage(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        return ((GoContentFacet)context.getRepository().facet(GoContentFacet.class)).getAsset(path).map(FluentAsset::download);
    }

    private Optional<Content> getInfo(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = GolangPathUtils.assetPath(state);
        GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(state);
        return ((GoContentFacet)context.getRepository().facet(GoContentFacet.class)).getInfo(path, golangAttributes);
    }
}

