/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.datastore.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.datastore.GoContentFacet;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangInfo;
import com.sonatype.nexus.repository.golang.internal.util.CompressedContentExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="go")
public class GoContentFacetImpl
extends ContentFacetSupport
implements GoContentFacet {
    private static final String GO_MOD_FILENAME = "go.mod";
    private static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final CompressedContentExtractor compressedContentExtractor;

    @Inject
    public GoContentFacetImpl(@Named(value="go") FormatStoreManager formatStoreManager, CompressedContentExtractor compressedContentExtractor) {
        super(formatStoreManager);
        this.compressedContentExtractor = (CompressedContentExtractor)((Object)Preconditions.checkNotNull((Object)((Object)compressedContentExtractor)));
    }

    @Override
    public void upload(String path, GolangAttributes golangAttributes, Payload payload) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)golangAttributes);
        Preconditions.checkNotNull((Object)payload);
        FluentAsset packageAsset = this.saveComponentAndAsset(path, payload, AssetKind.PACKAGE, golangAttributes);
        this.extractAndSaveMod(packageAsset, golangAttributes);
    }

    @Override
    public Optional<Content> getVersions(String module) {
        Preconditions.checkNotNull((Object)module);
        Iterable<FluentComponent> components = this.getComponents(module);
        List versions = StreamSupport.stream(components.spliterator(), false).map(Component::version).collect(Collectors.toList());
        if (versions.isEmpty()) {
            return Optional.empty();
        }
        String listOfVersions = String.join((CharSequence)"\n", versions);
        BytesPayload payload = new BytesPayload(listOfVersions.getBytes(StandardCharsets.UTF_8), "text/plain");
        Content content = new Content((Payload)payload);
        return Optional.of(content);
    }

    @Override
    public Optional<FluentAsset> getAsset(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(this.normalizeAssetPath(assetPath)).find();
    }

    @Override
    public Optional<Content> getInfo(String path, GolangAttributes golangAttributes) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)golangAttributes);
        String newPath = this.getZipAssetPathFromInfoPath(path);
        return this.assets().path(this.normalizeAssetPath(newPath)).find().flatMap(Asset::blob).map(assetBlob -> this.doGetInfo(assetBlob.blobCreated(), golangAttributes)).map(Content::new);
    }

    private Payload doGetInfo(OffsetDateTime blobCreated, GolangAttributes goAttributes) {
        GolangInfo goInfo = new GolangInfo(goAttributes.getVersion(), blobCreated.toString());
        try {
            String info = MAPPER.writeValueAsString((Object)goInfo);
            byte[] bytes = info.getBytes(StandardCharsets.UTF_8);
            return new BytesPayload(bytes, "application/json");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Unable to convert %s to json", goInfo), e);
        }
    }

    private void extractAndSaveMod(FluentAsset packageAsset, GolangAttributes golangAttributes) {
        String packageAssetPath;
        Content content = packageAsset.download();
        if (this.goModExistsInZip((Payload)content, packageAssetPath = packageAsset.path())) {
            String moduleAssetPath = packageAssetPath.replace(".zip", ".mod");
            Payload payload = this.getModAsPayload((Payload)content, packageAssetPath);
            this.saveComponentAndAsset(moduleAssetPath, payload, AssetKind.MODULE, golangAttributes);
        }
    }

    private boolean goModExistsInZip(Payload content, String path) {
        return this.compressedContentExtractor.fileExists(content, path, GO_MOD_FILENAME);
    }

    private Payload getModAsPayload(Payload content, String path) {
        return new StreamPayload(() -> this.doGetModAsStream(content, path), -1L, "text/plain");
    }

    private String getZipAssetPathFromInfoPath(String path) {
        return path.replace(".info", ".zip");
    }

    /*
     * Loose catch block
     */
    private InputStream doGetModAsStream(Payload content, String path) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream inputStream;
                InputStream inputStream2;
                InputStream contentStream;
                block18: {
                    block17: {
                        contentStream = content.openInputStream();
                        inputStream2 = this.compressedContentExtractor.extractFile(contentStream, GO_MOD_FILENAME);
                        Preconditions.checkNotNull((Object)inputStream2, (Object)String.format("Unable to find file %s in %s", GO_MOD_FILENAME, path));
                        inputStream = inputStream2;
                        if (inputStream2 == null) break block17;
                        inputStream2.close();
                    }
                    if (contentStream == null) break block18;
                    contentStream.close();
                }
                return inputStream;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (contentStream != null) {
                                contentStream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to open content %s", path), e);
        }
    }

    @Override
    public FluentAsset saveComponentAndAsset(String path, Payload payload, AssetKind assetKind, GolangAttributes golangAttributes) {
        FluentComponent component = this.findOrCreateComponent(golangAttributes.getModule(), golangAttributes.getVersion());
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(this.normalizeAssetPath(path)).kind(assetKind.name()).blob(tempBlob).component((Component)component).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentComponent findOrCreateComponent(String name, String version) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        return this.components().name(name).version(version).getOrCreate();
    }

    @Override
    public FluentAsset saveAsset(String path, Payload payload, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(this.normalizeAssetPath(path)).kind(assetKind.name()).blob(tempBlob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Iterable<FluentComponent> getComponents(String module) {
        String filterString = "name = #{filterParams.componentNameParam}";
        Map<String, String> params = Collections.singletonMap("componentNameParam", module);
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.components().byFilter(filterString, params)).browse(arg_0, arg_1));
    }

    private String normalizeAssetPath(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

