/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="go")
@Singleton
public class GolangContentValidator
extends ComponentSupport
implements ContentValidator {
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public GolangContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        String modifiedContentName = this.modifyContentName(contentName);
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, modifiedContentName, declaredContentType);
    }

    private String modifyContentName(@Nullable String contentName) {
        if (contentName != null) {
            if (contentName.endsWith(".mod")) {
                return String.valueOf(contentName) + ".txt";
            }
            if (contentName.endsWith("/list")) {
                return String.valueOf(contentName) + ".json";
            }
        }
        return contentName;
    }
}

