/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webresources;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.webresources.DelegatingWebResource;
import org.sonatype.nexus.webresources.WebResource;

public abstract class GeneratedWebResource
implements WebResource,
WebResource.Prepareable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public long getLastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Preparation required");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Preparation required");
    }

    @Override
    public WebResource prepare() throws IOException {
        return new DelegatingWebResource(this){
            private final byte[] content;
            {
                this.content = GeneratedWebResource.this.generate();
                Preconditions.checkState((this.content != null ? 1 : 0) != 0);
                GeneratedWebResource.this.log.trace("Generated: {}, {} bytes", (Object)this.getPath(), (Object)this.content.length);
            }

            @Override
            public long getSize() {
                return this.content.length;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.content);
            }
        };
    }

    protected abstract byte[] generate() throws IOException;
}

