/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.ssl.plugin.internal.ui.CertificateXO;
import com.sonatype.nexus.ssl.plugin.validator.PemCertificate;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"ssl_TrustStore"})
public class TrustStoreComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private TrustStore trustStore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public TrustStoreComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = TrustStoreComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    public List<CertificateXO> read() {
        CallSite[] callSiteArray = TrustStoreComponent.$getCallSiteArray();
        public class _read_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _read_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object certificate) {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, certificate, (Object)true);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _read_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "asCertificateXO";
                return new CallSiteArray(_read_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _read_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty((Object)this.trustStore), (Object)new _read_closure1((Object)this, (Object)this)), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:create"})
    @Validate
    public CertificateXO create(@NotBlank @PemCertificate String pem) {
        CallSite[] callSiteArray = TrustStoreComponent.$getCallSiteArray();
        Certificate certificate = (Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(CertificateUtil.class, (Object)pem), Certificate.class);
        callSiteArray[3].call((Object)this.trustStore, (Object)certificate, callSiteArray[4].callStatic(CertificateUtil.class, (Object)certificate));
        return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callStatic(TrustStoreComponent.class, (Object)certificate, (Object)true), CertificateXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:delete"})
    @Validate
    public void remove(@NotEmpty String id) {
        CallSite[] callSiteArray = TrustStoreComponent.$getCallSiteArray();
        callSiteArray[6].call((Object)this.trustStore, (Object)id);
    }

    static CertificateXO asCertificateXO(Certificate certificate, boolean inTrustStore) {
        CallSite[] callSiteArray = TrustStoreComponent.$getCallSiteArray();
        String fingerprint = ShortTypeHandling.castToString((Object)callSiteArray[7].callStatic(CertificateUtil.class, (Object)certificate));
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)certificate, X509Certificate.class);
            Map subjectRdns = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call(CertificateUtil.class, (Object)x509Certificate), Map.class);
            Map issuerRdns = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].call(CertificateUtil.class, (Object)x509Certificate), Map.class);
            return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callConstructor(CertificateXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", fingerprint, "pem", callSiteArray[11].call(CertificateUtil.class, (Object)certificate), "fingerprint", fingerprint, "serialNumber", callSiteArray[12].callGetProperty((Object)x509Certificate), "subjectCommonName", callSiteArray[13].call((Object)subjectRdns, (Object)"CN"), "subjectOrganization", callSiteArray[14].call((Object)subjectRdns, (Object)"O"), "subjectOrganizationalUnit", callSiteArray[15].call((Object)subjectRdns, (Object)"OU"), "issuerCommonName", callSiteArray[16].call((Object)issuerRdns, (Object)"CN"), "issuerOrganization", callSiteArray[17].call((Object)issuerRdns, (Object)"O"), "issuerOrganizationalUnit", callSiteArray[18].call((Object)issuerRdns, (Object)"OU"), "issuedOn", callSiteArray[19].callGetProperty(callSiteArray[20].callGetProperty((Object)x509Certificate)), "expiresOn", callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty((Object)x509Certificate)), "inTrustStore", inTrustStore})), CertificateXO.class);
        }
        return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(CertificateXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", fingerprint, "pem", callSiteArray[24].call(CertificateUtil.class, (Object)certificate), "fingerprint", fingerprint})), CertificateXO.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != TrustStoreComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "collect";
        stringArray[1] = "trustedCertificates";
        stringArray[2] = "decodePEMFormattedCertificate";
        stringArray[3] = "importTrustCertificate";
        stringArray[4] = "calculateFingerprint";
        stringArray[5] = "asCertificateXO";
        stringArray[6] = "removeTrustCertificate";
        stringArray[7] = "calculateFingerprint";
        stringArray[8] = "getSubjectRdns";
        stringArray[9] = "getIssuerRdns";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "serializeCertificateInPEM";
        stringArray[12] = "serialNumber";
        stringArray[13] = "get";
        stringArray[14] = "get";
        stringArray[15] = "get";
        stringArray[16] = "get";
        stringArray[17] = "get";
        stringArray[18] = "get";
        stringArray[19] = "time";
        stringArray[20] = "notBefore";
        stringArray[21] = "time";
        stringArray[22] = "notAfter";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "serializeCertificateInPEM";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[25];
        TrustStoreComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(TrustStoreComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = TrustStoreComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

