/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sonatype.nexus.ssl.plugin.internal.rest.CertificateApiResourceDoc;
import com.sonatype.nexus.ssl.plugin.validator.HostnameOrIpAddress;
import com.sonatype.nexus.ssl.plugin.validator.PemCertificate;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.ssl.ApiCertificate;
import org.sonatype.nexus.ssl.CertificateRetriever;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.KeyNotFoundException;
import org.sonatype.nexus.ssl.KeystoreException;
import org.sonatype.nexus.ssl.TrustStore;

@Produces(value={"application/json"})
public class CertificateApiResource
extends ComponentSupport
implements Resource,
CertificateApiResourceDoc {
    private static final String CERTIFICATE_MISSING_MESSAGE = "No certificate with alias '%s' in trust store.";
    private TrustStore trustStore;
    private CertificateRetriever certificateRetriever;
    private ObjectWriter stringWriter = new ObjectMapper().writerFor(String.class);

    @Inject
    public CertificateApiResource(TrustStore trustStore, CertificateRetriever certificateRetriever) {
        this.certificateRetriever = certificateRetriever;
        this.trustStore = trustStore;
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    public ApiCertificate retrieveCertificate(@NotNull @NotEmpty @HostnameOrIpAddress @QueryParam(value="host") String host, @DefaultValue(value="443") @QueryParam(value="port") Integer port, @QueryParam(value="protocolHint") String protocolHint) {
        try {
            Certificate[] certificates = this.certificateRetriever.retrieveCertificates(host, port, protocolHint);
            if (certificates == null || certificates.length == 0) {
                throw this.createWebException(Response.Status.BAD_REQUEST, "Unable to retrieve certificate from host: " + host);
            }
            return ApiCertificate.convert((Certificate)certificates[0]);
        }
        catch (UnknownHostException unknownHostException) {
            throw this.createWebException(Response.Status.BAD_REQUEST, "Unknown host " + host);
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve certificate from host:{} on port:{} with protocolHint:{}", new Object[]{host, port, protocolHint, e});
            throw this.createWebException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    @GET
    @Path(value="truststore")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    public List<ApiCertificate> getTrustStoreCertificates() {
        try {
            return this.trustStore.getTrustedCertificates().stream().map(this::convertOrNull).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
    }

    @Override
    @POST
    @Path(value="truststore/")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:create"})
    public Response addCertificate(@NotBlank @PemCertificate String pem) {
        Certificate certificate = null;
        String fingerprint = null;
        try {
            certificate = CertificateUtil.decodePEMFormattedCertificate((String)pem);
            fingerprint = CertificateUtil.calculateFingerprint((Certificate)certificate);
            this.trustStore.getTrustedCertificate(fingerprint);
            throw this.createWebException(Response.Status.CONFLICT, "A certificate already exists with the id: '" + fingerprint + "'.");
        }
        catch (KeyNotFoundException keyNotFoundException) {
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
        catch (CertificateException e) {
            this.log.debug("A certificate error occurred during import", (Throwable)e);
            throw this.createWebException(Response.Status.BAD_REQUEST, "The certificate is invalid. " + e.getMessage());
        }
        this.importCertificate(certificate);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.convert(fingerprint, certificate)).build();
    }

    @Override
    @DELETE
    @Path(value="truststore/{id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:delete"})
    public void removeCertificate(@PathParam(value="id") String id) {
        try {
            this.getTrustedCertificate(id);
            this.trustStore.removeTrustCertificate(id);
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
    }

    private Certificate getTrustedCertificate(String id) {
        try {
            return this.trustStore.getTrustedCertificate(id);
        }
        catch (KeyNotFoundException e) {
            this.log.debug("No existing certificate with id {}", (Object)id, (Object)e);
            throw this.createWebException(Response.Status.NOT_FOUND, String.format(CERTIFICATE_MISSING_MESSAGE, id));
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
    }

    private Certificate importCertificate(Certificate certificate) {
        String id = null;
        try {
            id = CertificateUtil.calculateFingerprint((Certificate)certificate);
            return this.trustStore.importTrustCertificate(certificate, id);
        }
        catch (CertificateException e) {
            this.log.info("Unable to import certificate {}", (Object)id, (Object)e);
            throw this.createWebException(Response.Status.BAD_REQUEST, "Invalid certificate: " + e.getMessage());
        }
        catch (KeystoreException e) {
            this.log.error("An error occurred accessing the internal trust store.", (Throwable)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred accessing the trust store.");
        }
    }

    private ApiCertificate convert(String id, Certificate certificate) {
        try {
            return ApiCertificate.convert((Certificate)certificate);
        }
        catch (IOException | CertificateEncodingException | InvalidNameException e) {
            this.log.info("An error occurred serializing certificate '{}'", (Object)id, (Object)e);
            throw this.createWebException(Response.Status.INTERNAL_SERVER_ERROR, "An error occurred serializing the certificate after it was updated.");
        }
    }

    private ApiCertificate convertOrNull(Certificate certificate) {
        try {
            return ApiCertificate.convert((Certificate)certificate);
        }
        catch (IOException | CertificateEncodingException | InvalidNameException e) {
            this.log.info("Failed to convert certificate {}", (Object)certificate, (Object)e);
            return null;
        }
    }

    private WebApplicationMessageException createWebException(Response.Status status, String message) {
        try {
            return new WebApplicationMessageException(status, (Object)this.stringWriter.writeValueAsString((Object)message), "application/json");
        }
        catch (JsonProcessingException e) {
            this.log.warn("An error occurred serializing an error message", (Throwable)e);
            return new WebApplicationMessageException(status, (Object)"\"An error occurred serializing the error message. See nexus log.\"", "application/json");
        }
    }
}

