/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreData;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreDataEntityAdapter;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreStorage;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;
import org.sonatype.nexus.ssl.spi.KeyStoreStorageManager;

@Named(value="ssl")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientKeyStoreStorageManager
extends StateGuardLifecycleSupport
implements KeyStoreStorageManager {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientKeyStoreDataEntityAdapter entityAdapter;
    private final EventManager eventManager;
    private final Collection<OrientKeyStoreStorage> storages = new ConcurrentLinkedQueue<OrientKeyStoreStorage>();

    @Inject
    public OrientKeyStoreStorageManager(@Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientKeyStoreDataEntityAdapter entityAdapter, EventManager eventManager) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientKeyStoreDataEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doStop() throws Exception {
        this.storages.forEach(arg_0 -> ((EventManager)this.eventManager).unregister(arg_0));
        this.storages.clear();
    }

    @Guarded(by={"STARTED"})
    public KeyStoreStorage createStorage(String keyStoreName) {
        Preconditions.checkNotNull((Object)keyStoreName);
        OrientKeyStoreStorage storage = new OrientKeyStoreStorage(this, "ssl/" + keyStoreName);
        this.eventManager.register((Object)storage);
        this.storages.add(storage);
        return storage;
    }

    @Guarded(by={"STARTED"})
    @Nullable
    public OrientKeyStoreData load(String keyStoreName) {
        Preconditions.checkNotNull((Object)keyStoreName);
        return (OrientKeyStoreData)((Object)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.load(db, keyStoreName)));
    }

    @Guarded(by={"STARTED"})
    public void save(OrientKeyStoreData entity) {
        Preconditions.checkNotNull((Object)((Object)entity));
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.save(db, entity));
    }
}

