/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore.orient;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreDataEvent;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreData;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreDataCreatedEvent;
import com.sonatype.nexus.ssl.plugin.internal.keystore.orient.OrientKeyStoreDataUpdatedEvent;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class OrientKeyStoreDataEntityAdapter
extends IterableEntityAdapter<OrientKeyStoreData> {
    private static final String DB_CLASS = new OClassNameBuilder().type("key_store").build();
    private static final String P_NAME = "name";
    private static final String P_BYTES = "bytes";
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();

    public OrientKeyStoreDataEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_BYTES, OType.BINARY).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected OrientKeyStoreData newEntity() {
        return new OrientKeyStoreData();
    }

    protected void readFields(ODocument document, OrientKeyStoreData entity) {
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setBytes((byte[])((byte[])document.field(P_BYTES, OType.BINARY)).clone());
    }

    protected void writeFields(ODocument document, OrientKeyStoreData entity) {
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_BYTES, entity.getBytes().clone());
    }

    @Nullable
    private ODocument findDocument(ODatabaseDocumentTx db, String name) {
        String query = "SELECT FROM " + DB_CLASS + " WHERE " + P_NAME + " = ?";
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[]{name});
        return results.stream().findFirst().orElse(null);
    }

    @Nullable
    public OrientKeyStoreData load(ODatabaseDocumentTx db, String name) {
        ODocument document = this.findDocument(db, name);
        if (document != null) {
            return (OrientKeyStoreData)this.readEntity((OIdentifiable)document);
        }
        return null;
    }

    public void save(ODatabaseDocumentTx db, OrientKeyStoreData entity) {
        ODocument document = this.findDocument(db, entity.getName());
        if (document != null) {
            this.writeEntity(document, (Entity)entity);
        } else {
            this.addEntity(db, (Entity)entity);
        }
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        KeyStoreDataEvent event;
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String name = (String)document.field(P_NAME);
        switch (eventKind) {
            case CREATE: {
                event = new OrientKeyStoreDataCreatedEvent((EntityMetadata)metadata, name);
                break;
            }
            case UPDATE: {
                event = new OrientKeyStoreDataUpdatedEvent((EntityMetadata)metadata, name);
                break;
            }
            default: {
                event = null;
            }
        }
        if (event != null) {
            this.log.debug("Emitted {} event for key store {} with metadata {}", new Object[]{eventKind, name, metadata});
        }
        return event;
    }
}

