/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreStorageManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;

public class KeyStoreStorageImpl
implements KeyStoreStorage {
    private final KeyStoreStorageManagerImpl storage;
    private final String keyStoreName;

    public KeyStoreStorageImpl(KeyStoreStorageManagerImpl storage, String keyStoreName) {
        this.storage = (KeyStoreStorageManagerImpl)((Object)Preconditions.checkNotNull((Object)((Object)storage)));
        this.keyStoreName = (String)Preconditions.checkNotNull((Object)keyStoreName);
    }

    public boolean exists() {
        return this.storage.exists(this.keyStoreName);
    }

    public boolean modified() {
        return false;
    }

    public void load(KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayInputStream in = this.storage.load(this.keyStoreName);){
            keyStore.load(in, password);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(KeyStore keyStore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(16384);){
            keyStore.store(out, password);
            this.storage.save(this.keyStoreName, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

