/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;

@Singleton
public class MavenMetadataContentValidator
extends ComponentSupport {
    public void validate(String path, InputStream mavenMetadata) {
        try {
            Metadata metadata = MavenModels.readMetadata(mavenMetadata);
            if (metadata == null) {
                throw new InvalidContentException("Metadata at path " + path + " is not a valid maven-metadata.xml");
            }
            if (StringUtils.isNotEmpty((CharSequence)metadata.getGroupId())) {
                this.validatePath(path, metadata);
            } else {
                this.log.debug("No groupId found in maven-metadata.xml therefore skipping validation");
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to read maven-metadata.xml at path {}", (Object)path, (Object)e);
            throw new InvalidContentException("Unable to read maven-metadata.xml reason: " + e.getMessage());
        }
    }

    private void validatePath(String path, Metadata metadata) {
        String version = this.getMetadataVersion(metadata);
        MavenPath expectedPath = MetadataUtils.metadataPath(metadata.getGroupId(), metadata.getArtifactId(), version);
        if (!path.equals(expectedPath.getPath())) {
            String pattern = "Invalid maven-metadata.xml GAV %s, %s, %s does not match request path %s";
            String message = String.format(pattern, metadata.getGroupId(), metadata.getArtifactId(), metadata.getVersion(), path);
            this.log.warn("maven-metadata.xml path {} does not match the expected path {}", (Object)path, (Object)expectedPath.getPath());
            throw new InvalidContentException(message);
        }
    }

    private String getMetadataVersion(Metadata metadata) {
        if (metadata.getVersion() != null && metadata.getVersion().contains("-SNAPSHOT")) {
            this.log.debug("maven-metadata.xml contains a SNAPSHOT version ({}) therefore the version is expected to be part of the path", (Object)metadata.getVersion());
            return metadata.getVersion();
        }
        this.log.debug("maven-metadata.xml version ({}) is either null or not a SNAPSHOT therefore not expected in the path", (Object)metadata.getVersion());
        return null;
    }
}

