/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.utils.HashedPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public final class MavenIOUtils {
    private MavenIOUtils() {
    }

    public static HashedPayload createStreamPayload(Path path, String contentType, Writer writer) throws IOException {
        Map<HashAlgorithm, HashingOutputStream> hashingStreams = MavenIOUtils.writeToPath(path, writer);
        Map<HashAlgorithm, HashCode> hashCodes = MavenIOUtils.generateHashCodes(hashingStreams);
        return new HashedPayload((Payload)MavenIOUtils.aStreamPayload(path, contentType), hashCodes);
    }

    private static Map<HashAlgorithm, HashingOutputStream> writeToPath(Path path, Writer writer) throws IOException {
        HashMap<HashAlgorithm, HashingOutputStream> hashingStreams = new HashMap<HashAlgorithm, HashingOutputStream>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BufferedOutputStream os = outputStream;
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                os = new HashingOutputStream(hashType.getHashAlgorithm().function(), (OutputStream)os);
                hashingStreams.put(hashType.getHashAlgorithm(), (HashingOutputStream)os);
                ++n2;
            }
            writer.write(os);
            ((OutputStream)os).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return hashingStreams;
    }

    private static Map<HashAlgorithm, HashCode> generateHashCodes(Map<HashAlgorithm, HashingOutputStream> hashingStreams) {
        HashMap<HashAlgorithm, HashCode> hashCodes = new HashMap<HashAlgorithm, HashCode>();
        for (Map.Entry<HashAlgorithm, HashingOutputStream> entry : hashingStreams.entrySet()) {
            hashCodes.put(entry.getKey(), entry.getValue().hash());
        }
        return hashCodes;
    }

    private static StreamPayload aStreamPayload(Path path, String contentType) throws IOException {
        return new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path), contentType);
    }

    public static Map<MavenPath.HashType, Payload> hashesToPayloads(Map<HashAlgorithm, HashCode> hashCodes) {
        EnumMap<MavenPath.HashType, Payload> payloadByHash = new EnumMap<MavenPath.HashType, Payload>(MavenPath.HashType.class);
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            HashCode hashCode = hashCodes.get(hashType.getHashAlgorithm());
            if (hashCode != null) {
                StringPayload payload = new StringPayload(hashCode.toString(), "text/plain");
                payloadByHash.put(hashType, (Payload)payload);
            }
            ++n2;
        }
        return payloadByHash;
    }

    public static interface Writer {
        public void write(OutputStream var1) throws IOException;
    }
}

