/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.search;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.query.SearchResultComponentGeneratorSupport;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

@Singleton
@Named(value="maven2")
public class Maven2SearchResultComponentGenerator
extends SearchResultComponentGeneratorSupport {
    @Inject
    public Maven2SearchResultComponentGenerator(VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker) {
        super(variableResolverAdapterManager, repositoryManager, contentPermissionChecker);
    }

    public ComponentSearchResult from(ComponentSearchResult hit, Set<String> componentIdSet) {
        hit.setRepositoryName(this.getPrivilegedRepositoryName(hit));
        Optional<String> baseVersion = Optional.ofNullable(hit.getAnnotation("baseVersion")).map(Object::toString).filter(Objects::nonNull).filter(((Predicate<String>)String::isEmpty).negate());
        if (baseVersion.isPresent()) {
            return this.createComponentForBaseVersion(hit, componentIdSet, baseVersion.get());
        }
        return hit;
    }

    private ComponentSearchResult createComponentForBaseVersion(ComponentSearchResult hit, Set<String> componentIdSet, String baseVersion) {
        ComponentSearchResult component = null;
        String baseVersionId = String.valueOf(hit.getRepositoryName()) + ":" + hit.getGroup() + ":" + hit.getName() + ":" + baseVersion;
        if (!componentIdSet.contains(baseVersionId)) {
            boolean isSnapshot = Maven2SearchResultComponentGenerator.isSnapshotId(baseVersionId);
            component = new ComponentSearchResult();
            component.setId(isSnapshot ? baseVersionId : hit.getId());
            component.setRepositoryName(hit.getRepositoryName());
            component.setGroup(hit.getGroup());
            component.setName(hit.getName());
            component.setFormat(hit.getFormat());
            component.setAssets(hit.getAssets());
            component.setVersion(baseVersion);
        }
        return component;
    }

    public static boolean isSnapshotId(String id) {
        return Objects.nonNull(id) && id.endsWith("-SNAPSHOT");
    }
}

