/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.maven.PurgeUnusedSnapshotsFacet;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PurgeUnusedSnapshotsFacetImpl
extends FacetSupport
implements PurgeUnusedSnapshotsFacet {
    private static final String UNUSED_QUERY = "LET $a = (SELECT FROM component WHERE bucket = %s AND @rid > %s ORDER BY @rid LIMIT %d); LET $b = (SELECT component, max(ifnull(last_downloaded, blob_created)) as lastdownloaded FROM asset WHERE (%s) GROUP BY component ORDER BY component); SELECT FROM $b WHERE (component.attributes.maven2.baseVersion LIKE '%%SNAPSHOT' AND lastdownloaded < '%s') OR component = $a[%d];";
    private static final String UNUSED_WHERE_QUERY = "(bucket = %s AND component = $a[%d])";
    private final ComponentEntityAdapter componentEntityAdapter;
    private final Type groupType;
    private final Type hostedType;
    private final int findUnusedLimit;
    private ORID lastComponent;

    @Inject
    public PurgeUnusedSnapshotsFacetImpl(ComponentEntityAdapter componentEntityAdapter, @Named(value="group") Type groupType, @Named(value="hosted") Type hostedType, @Named(value="${nexus.tasks.purgeUnusedSnapshots.findUnusedLimit:-50}") int findUnusedLimit) {
        this.componentEntityAdapter = (ComponentEntityAdapter)Preconditions.checkNotNull((Object)componentEntityAdapter);
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.findUnusedLimit = findUnusedLimit;
        Preconditions.checkArgument((findUnusedLimit >= 10 && findUnusedLimit <= 1000 ? 1 : 0) != 0, (Object)"nexus.tasks.purgeUnusedSnapshots.findUnusedLimit must be between 10 and 1000");
    }

    @Override
    @Guarded(by={"STARTED"})
    public void purgeUnusedSnapshots(int numberOfDays) {
        Preconditions.checkArgument((numberOfDays > 0 ? 1 : 0) != 0, (Object)"Number of days must be greater than zero");
        this.log.info("Purging unused snapshots {} days or older from repository {}", (Object)numberOfDays, (Object)this.getRepository().getName());
        if (this.groupType.equals((Object)this.getRepository().getType())) {
            this.processAsGroup((MavenGroupFacet)this.facet(MavenGroupFacet.class), numberOfDays);
        } else if (this.hostedType.equals((Object)this.getRepository().getType())) {
            this.purgeSnapshotsFromRepository(numberOfDays);
        } else {
            this.log.debug("Skipping repository {}, is not group or hosted", (Object)this.getRepository().getName());
        }
    }

    private void processAsGroup(MavenGroupFacet groupFacet, int numberOfDays) {
        groupFacet.members().stream().filter(member -> this.hostedType.equals((Object)member.getType()) || this.groupType.equals((Object)member.getType())).forEach(member -> ((PurgeUnusedSnapshotsFacet)member.facet(PurgeUnusedSnapshotsFacet.class)).purgeUnusedSnapshots(numberOfDays));
    }

    private void purgeSnapshotsFromRepository(int numberOfDays) {
        LocalDate olderThan = LocalDate.now().minusDays(numberOfDays);
        UnitOfWork.beginBatch((Supplier)((StorageFacet)this.facet(StorageFacet.class)).txSupplier());
        try {
            this.deleteUnusedSnapshotComponents(olderThan);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void deleteUnusedSnapshotComponents(LocalDate olderThan) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Repository repo = this.getRepository();
        long totalComponents = tx.countComponents(Query.builder().build(), Collections.singletonList(repo));
        this.log.info("Found {} total components in repository {} to evaluate for unused snapshots", (Object)totalComponents, (Object)repo.getName());
        ORID bucketId = AttachedEntityHelper.id((Entity)tx.findBucket(this.getRepository()));
        String unusedWhereTemplate = this.getUnusedWhere(bucketId);
        long skipCount = 0L;
        this.lastComponent = new ORecordId(-1, -1L);
        while (skipCount < totalComponents && !this.isCanceled()) {
            this.log.info(TaskLoggingMarkers.PROGRESS, String.format("Processing components [%.2f%%] complete", (double)skipCount / (double)totalComponents * 100.0));
            for (Component component : this.findNextPageOfUnusedSnapshots(tx, olderThan, bucketId, unusedWhereTemplate)) {
                if (this.isCanceled()) {
                    return;
                }
                this.deleteComponent(component);
            }
            tx.commit();
            tx.begin();
            skipCount += (long)this.findUnusedLimit;
        }
    }

    private List<Component> findNextPageOfUnusedSnapshots(StorageTx tx, LocalDate olderThan, ORID bucketId, String unusedWhereTemplate) {
        String query = String.format(UNUSED_QUERY, bucketId, this.lastComponent, this.findUnusedLimit, unusedWhereTemplate, olderThan, this.findUnusedLimit - 1);
        List result = (List)tx.getDb().command((OCommandRequest)new OCommandScript("sql", query)).execute(new Object[0]);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        ODocument lastDoc = (ODocument)((ODocument)Iterables.getLast((Iterable)result)).field("component");
        this.lastComponent = lastDoc.getIdentity();
        Date olderThanDate = Date.valueOf(olderThan);
        return result.stream().filter(entries -> {
            java.util.Date lastDownloaded = (java.util.Date)entries.field("lastdownloaded");
            return lastDownloaded.compareTo(olderThanDate) < 0;
        }).map(doc -> (Component)this.componentEntityAdapter.readEntity((OIdentifiable)doc.field("component"))).filter(component -> {
            String baseVersion = (String)component.attributes().child("maven2").get("baseVersion");
            return baseVersion != null && baseVersion.endsWith("SNAPSHOT");
        }).collect(Collectors.toList());
    }

    private void deleteComponent(Component component) {
        this.log.debug("Deleting unused snapshot component {}", (Object)component);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        tx.deleteComponent(component);
        NestedAttributesMap attributes = component.formatAttributes();
        String groupId = (String)attributes.get("groupId", String.class);
        String artifactId = (String)attributes.get("artifactId", String.class);
        String baseVersion = (String)attributes.get("baseVersion", String.class);
        try {
            Bucket bucket = tx.findBucket(this.getRepository());
            ((OrientMavenFacet)this.getRepository().facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId, artifactId, baseVersion);
            ((OrientMavenFacet)this.getRepository().facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId, artifactId);
            ((OrientMavenFacet)this.getRepository().facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    String getUnusedWhere(ORID bucketId) {
        return IntStream.range(0, this.findUnusedLimit).mapToObj(i -> String.format(UNUSED_WHERE_QUERY, bucketId, i)).collect(Collectors.joining(" OR "));
    }

    private boolean isCanceled() {
        try {
            CancelableHelper.checkCancellation();
            return false;
        }
        catch (TaskInterruptedException taskInterruptedException) {
            this.log.warn("Purge unused Maven snapshots job is canceled");
            return true;
        }
    }
}

