/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public final class OrientMetadataUtils {
    private static Logger log = LoggerFactory.getLogger(OrientMetadataUtils.class);
    private static final String METADATA_REBUILD_KEY = "forceRebuild";

    private OrientMetadataUtils() {
    }

    public static boolean exists(Repository repository, MavenPath mavenPath) throws IOException {
        return ((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).exists(mavenPath);
    }

    @Nullable
    public static Metadata read(Repository repository, MavenPath mavenPath) throws IOException {
        Content content;
        block6: {
            content = ((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).get(mavenPath);
            if (content != null) break block6;
            return null;
        }
        try {
            Metadata metadata = MavenModels.readMetadata(content.openInputStream());
            if (metadata == null) {
                log.warn("Corrupted metadata {} @ {}", (Object)repository.getName(), (Object)mavenPath.getPath());
            }
            return metadata;
        }
        catch (BlobStoreException | MissingBlobException e) {
            if (log.isDebugEnabled()) {
                log.warn(String.format("Found missing blob for metadata path %s, will return null (not found) caused by:", mavenPath.getPath()), e);
            } else {
                log.warn("Found missing blob for metadata path {}, will return null (not found) caused by {}", (Object)mavenPath.getPath(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public static void write(Repository repository, MavenPath mavenPath, Metadata metadata) throws IOException {
        OrientMavenFacet mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MavenModels.writeMetadata(buffer, metadata);
        mavenFacet.put(mavenPath, (Payload)new BytesPayload(buffer.toByteArray(), "application/xml"));
        Map hashCodes = (Map)mavenFacet.get(mavenPath).getAttributes().require("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
        Preconditions.checkState((hashCodes != null ? 1 : 0) != 0, (Object)"hashCodes");
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            MavenPath checksumPath = mavenPath.hash(hashType);
            HashCode hashCode = (HashCode)hashCodes.get(hashType.getHashAlgorithm());
            Preconditions.checkState((hashCode != null ? 1 : 0) != 0, (String)"hashCode: type=%s", (Object)((Object)hashType));
            mavenFacet.put(checksumPath, (Payload)new StringPayload(hashCode.toString(), "text/plain"));
            ++n2;
        }
    }

    public static Set<String> delete(Repository repository, MavenPath mavenPath) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)mavenPath);
        try {
            return MavenFacetUtils.deleteWithHashes((OrientMavenFacet)repository.facet(OrientMavenFacet.class), mavenPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<String> deleteAndAddRebuildFlag(Repository repository, String groupId, String artifactId, String baseVersion) throws IOException {
        return (Set)Transactional.operation.throwing(IOException.class).withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            HashSet deletedPaths = Sets.newHashSet();
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(repository);
            deletedPaths.addAll(((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId, artifactId, baseVersion));
            deletedPaths.addAll(((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId, artifactId));
            deletedPaths.addAll(((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).maybeDeleteOrFlagToRebuildMetadata(bucket, groupId));
            return deletedPaths;
        });
    }

    public static void addRebuildFlag(Asset metadataAsset) {
        metadataAsset.formatAttributes().set(METADATA_REBUILD_KEY, (Object)true);
    }

    public static void removeRebuildFlag(Asset metadataAsset) {
        metadataAsset.formatAttributes().remove(METADATA_REBUILD_KEY);
    }

    public static boolean requiresRebuild(Asset metadataAsset) {
        Objects.requireNonNull(metadataAsset);
        if (Boolean.TRUE.equals(metadataAsset.formatAttributes().get(METADATA_REBUILD_KEY, (Object)false))) {
            return true;
        }
        CacheInfo cacheInfo = CacheInfo.extractFromAsset((Asset)metadataAsset);
        return cacheInfo != null && cacheInfo.isInvalidated();
    }
}

