/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.io.IOException;
import java.util.Optional;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataUtils;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;

public class OrientMetadataUpdater
extends AbstractMetadataUpdater {
    public OrientMetadataUpdater(boolean update, Repository repository) {
        super(update, repository);
    }

    @Override
    protected void update(MavenPath mavenPath, Maven2Metadata metadata) {
        try {
            TransactionalStoreBlob.operation.throwing(IOException.class).run(() -> super.update(mavenPath, metadata));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void replace(MavenPath mavenPath, Maven2Metadata metadata) {
        try {
            TransactionalStoreBlob.operation.throwing(IOException.class).run(() -> super.replace(mavenPath, metadata));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void write(MavenPath mavenPath, Metadata metadata) throws IOException {
        OrientMetadataUtils.write(this.repository, mavenPath, metadata);
    }

    @Override
    protected Optional<Metadata> read(MavenPath mavenPath) throws IOException {
        return Optional.ofNullable(OrientMetadataUtils.read(this.repository, mavenPath));
    }

    @Override
    protected void delete(MavenPath mavenPath) {
        OrientMetadataUtils.delete(this.repository, mavenPath);
    }
}

