/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataBuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalSession;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="orient")
@Priority(value=0x7FFFFFFF)
public class OrientMetadataRebuilder
extends AbstractMetadataRebuilder {
    @Inject
    public OrientMetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize, @Named(value="${nexus.maven.metadata.rebuild.timeoutSeconds:-60}") int timeoutSeconds) {
        super(bufferSize, timeoutSeconds);
    }

    @Override
    public boolean rebuild(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
        UnitOfWork.beginBatch((TransactionalSession)tx);
        try {
            boolean bl = this.rebuildInTransaction(repository, update, rebuildChecksums, groupId, artifactId, baseVersion);
            return bl;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public boolean rebuildInTransaction(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        return new OrientWorker(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, this.bufferSize, this.timeoutSeconds, new OrientMetadataUpdater(update, repository)).rebuildMetadata();
    }

    public boolean refreshInTransaction(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        return new OrientWorker(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, this.bufferSize, this.timeoutSeconds, new OrientMetadataUpdater(update, repository)).refreshMetadata();
    }

    @Override
    protected Set<String> deleteAllMetadataFiles(Repository repository, String groupId, String artifactId, String baseVersion) {
        StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
        UnitOfWork.beginBatch((TransactionalSession)tx);
        try {
            Set<String> set = super.deleteAllMetadataFiles(repository, groupId, artifactId, baseVersion);
            return set;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    protected Set<String> deleteGavMetadata(Repository repository, String groupId, String artifactId, String baseVersion) {
        MavenPath gavMetadataPath = MetadataUtils.metadataPath(groupId, artifactId, baseVersion);
        OrientMetadataUtils.delete(repository, gavMetadataPath);
        return MavenFacetUtils.getPathWithHashes(gavMetadataPath);
    }

    @Override
    public boolean exists(Repository repository, MavenPath mavenPath) {
        StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
        UnitOfWork.beginBatch((TransactionalSession)tx);
        try {
            boolean bl = ((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).exists(mavenPath);
            return bl;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public Set<String> deleteMetadata(Repository repository, List<String[]> gavs) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(gavs);
        ArrayList<MavenPath> pathBatch = new ArrayList<MavenPath>();
        for (String[] gav : gavs) {
            pathBatch.addAll(this.getPathsByGav(repository, gav[0], gav[1], gav[2]));
        }
        try {
            return MavenFacetUtils.deleteWithHashes((OrientMavenFacet)repository.facet(OrientMavenFacet.class), pathBatch);
        }
        catch (IOException e) {
            this.log.warn("Error encountered when deleting metadata: repository={}", (Object)repository);
            throw new RuntimeException(e);
        }
    }

    protected static class OrientWorker
    extends AbstractMetadataRebuilder.Worker {
        private final Map<String, Object> sqlParams = Maps.newHashMap();
        private final String sql;
        private final OrientMavenFacet mavenFacet;

        public OrientWorker(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, int bufferSize, int timeoutSeconds, AbstractMetadataUpdater metadataUpdater) {
            super(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, bufferSize, timeoutSeconds, metadataUpdater, ((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).getMavenPathParser());
            this.sql = this.buildSql(groupId, artifactId, baseVersion);
            this.mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        }

        private String buildSql(@Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
            this.sqlParams.put("bucket", this.findBucketORID(this.repository));
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("SELECT %s as groupId, %s as artifactId, set(%s.%s.%s) as baseVersions FROM %s WHERE %s=:bucket", "group", "name", "attributes", "maven2", "baseVersion", "component", "bucket"));
            if (!Strings.isNullOrEmpty((String)groupId)) {
                builder.append(" AND group=:groupId");
                this.sqlParams.put("groupId", groupId);
                if (!Strings.isNullOrEmpty((String)artifactId)) {
                    builder.append(" AND name=:artifactId");
                    this.sqlParams.put("artifactId", artifactId);
                    if (!Strings.isNullOrEmpty((String)baseVersion)) {
                        builder.append(" AND attributes.maven2.baseVersion=:baseVersion");
                        this.sqlParams.put("baseVersion", baseVersion);
                    }
                }
            }
            builder.append(" GROUP BY group, name");
            return builder.toString();
        }

        private ORID findBucketORID(Repository repository) {
            return (ORID)Transactional.operation.call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                return AttachedEntityHelper.id((Entity)tx.findBucket(repository));
            });
        }

        @Override
        protected List<Map<String, Object>> browseGAVs() {
            Iterable iterableGavs = (Iterable)Transactional.operation.call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                this.log.debug("Searching GAVs with Query='{}' and Parameters='{}'", (Object)this.sql, this.sqlParams);
                return tx.browse(this.sql, this.sqlParams, this.bufferSize, this.timeoutSeconds);
            });
            return StreamSupport.stream(iterableGavs.spliterator(), false).map(odocument -> ImmutableMap.of((Object)"groupId", (Object)odocument.field("groupId", OType.STRING), (Object)"artifactId", (Object)odocument.field("artifactId", OType.STRING), (Object)"baseVersions", (Object)odocument.field("baseVersions", OType.EMBEDDEDSET))).collect(Collectors.toList());
        }

        @Override
        protected Content get(MavenPath mavenPath) throws IOException {
            return this.mavenFacet.get(mavenPath);
        }

        @Override
        protected void put(MavenPath mavenPath, Payload payload) throws IOException {
            this.mavenFacet.put(mavenPath, payload);
        }

        @Override
        protected Optional<HashCode> getChecksum(MavenPath mavenPath, MavenPath.HashType hashType) {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return Optional.ofNullable(MavenFacetUtils.findAsset(tx, tx.findBucket(this.repository), mavenPath)).map(asset -> asset.getChecksum(hashType.getHashAlgorithm()));
        }

        @Override
        protected void rebuildMetadataInner(String groupId, String artifactId, Set<String> baseVersions, MultipleFailures failures) {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            this.metadataBuilder.onEnterArtifactId(artifactId);
            for (String baseVersion : baseVersions) {
                CancelableHelper.checkCancellation();
                TransactionalStoreBlob.operation.run(() -> this.rebuildBaseVersion(groupId, artifactId, baseVersion, tx, failures));
            }
            Maven2Metadata artifactMetadata = this.metadataBuilder.onExitArtifactId();
            this.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, null), artifactMetadata, failures);
        }

        @Override
        protected boolean refreshArtifact(String groupId, String artifactId, Set<String> baseVersions, MultipleFailures failures) {
            boolean isRequestedVersion;
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            MavenPath metadataPath = MetadataUtils.metadataPath(groupId, artifactId, null);
            this.metadataBuilder.onEnterArtifactId(artifactId);
            boolean rebuiltAtLeastOneVersion = baseVersions.stream().map(v -> {
                CancelableHelper.checkCancellation();
                return (Boolean)TransactionalStoreBlob.operation.call(() -> this.refreshVersion(groupId, artifactId, (String)v, tx, failures));
            }).reduce(Boolean::logicalOr).orElse(false);
            Maven2Metadata newMetadata = this.metadataBuilder.onExitArtifactId();
            boolean bl = isRequestedVersion = StringUtils.equals((CharSequence)this.groupId, (CharSequence)groupId) && StringUtils.equals((CharSequence)this.artifactId, (CharSequence)artifactId) && StringUtils.equals((CharSequence)this.baseVersion, null);
            if (rebuiltAtLeastOneVersion || isRequestedVersion || this.requiresRebuild(tx, metadataPath)) {
                this.processMetadata(metadataPath, newMetadata, failures);
                return true;
            }
            this.log.debug("Skipping {}:{} for rebuild", (Object)groupId, (Object)artifactId);
            return false;
        }

        private boolean requiresRebuild(StorageTx tx, MavenPath metadataPath) {
            Bucket bucket = tx.findBucket(this.repository);
            Asset existingMetadata = MavenFacetUtils.findAsset(tx, bucket, metadataPath);
            return existingMetadata == null || OrientMetadataUtils.requiresRebuild(existingMetadata);
        }

        private Iterable<Component> fetchComponents(String groupId, String artifactId, String baseVersion, StorageTx tx) {
            Bucket bucket = tx.findBucket(this.repository);
            Query query = Query.builder().where("group").eq((Object)groupId).and("name").eq((Object)artifactId).build();
            return StreamSupport.stream(tx.browseComponents(query, bucket).spliterator(), false).filter(component -> {
                String thisVersion = (String)component.formatAttributes().get("baseVersion");
                return baseVersion.equals(thisVersion);
            }).collect(Collectors.toList());
        }

        private void rebuildBaseVersion(String groupId, String artifactId, String baseVersion, StorageTx tx, MultipleFailures failures) {
            this.metadataBuilder.onEnterBaseVersion(baseVersion);
            this.collectComponentAssetInformation(groupId, artifactId, baseVersion, tx, this.metadataBuilder);
            Maven2Metadata baseVersionMetadata = this.metadataBuilder.onExitBaseVersion();
            this.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, baseVersion), baseVersionMetadata, failures);
        }

        private void collectComponentAssetInformation(String groupId, String artifactId, String version, StorageTx tx, MetadataBuilder builder) {
            for (Component component : this.fetchComponents(groupId, artifactId, version, tx)) {
                CancelableHelper.checkCancellation();
                for (Asset asset : tx.browseAssets(component)) {
                    CancelableHelper.checkCancellation();
                    MavenPath mavenPath = this.mavenPathParser.parsePath(asset.name());
                    if (mavenPath.isSubordinate()) continue;
                    builder.addArtifactVersion(mavenPath);
                    if (this.rebuildChecksums) {
                        Arrays.stream(MavenPath.HashType.values()).forEach(hashType -> {
                            boolean bl = this.mayUpdateChecksum(mavenPath, (MavenPath.HashType)((Object)hashType));
                        });
                    }
                    String packaging = (String)component.formatAttributes().get("packaging", String.class);
                    this.log.debug("POM packaging: {}", (Object)packaging);
                    if (!"maven-plugin".equals(packaging)) continue;
                    MavenPath mainArtifact = mavenPath.locateMainArtifact("jar");
                    this.metadataBuilder.addPlugin(MetadataUtils.getPluginPrefix(mainArtifact, () -> this.get(mainArtifact).openInputStream()), artifactId, (String)component.formatAttributes().get("pom_name", String.class));
                }
            }
        }

        private boolean refreshVersion(String groupId, String artifactId, String version, StorageTx tx, MultipleFailures failures) {
            boolean isRequestedVersion;
            MavenPath metadataPath = MetadataUtils.metadataPath(groupId, artifactId, version);
            this.metadataBuilder.onEnterBaseVersion(version);
            this.collectComponentAssetInformation(groupId, artifactId, version, tx, this.metadataBuilder);
            Maven2Metadata newMetadata = this.metadataBuilder.onExitBaseVersion();
            boolean bl = isRequestedVersion = StringUtils.equals((CharSequence)this.groupId, (CharSequence)groupId) && StringUtils.equals((CharSequence)this.artifactId, (CharSequence)artifactId) && StringUtils.equals((CharSequence)this.baseVersion, (CharSequence)version);
            if (isRequestedVersion || this.requiresRebuild(tx, metadataPath)) {
                this.processMetadata(metadataPath, newMetadata, failures);
                return true;
            }
            this.log.debug("Skipping {}:{}:{} for rebuild", new Object[]{groupId, artifactId, version});
            return false;
        }
    }
}

