/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientMavenReplicationFacet
extends OrientReplicationFacetSupport {
    @Transactional
    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        try {
            OrientMavenFacet mavenFacet = (OrientMavenFacet)this.facet(OrientMavenFacet.class);
            MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            mavenFacet.put(mavenPath, assetBlob, (AttributesMap)assetAttributes);
            if (mavenPath.getCoordinates() != null) {
                this.replicateAssetAttributes(tx, mavenPath, assetAttributes);
                this.replicateComponent(tx, mavenPath, componentAttributes);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void replicateAssetAttributes(StorageTx tx, MavenPath mavenPath, NestedAttributesMap assetAttributes) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = MavenFacetUtils.findAsset(tx, bucket, mavenPath);
        asset.attributes(assetAttributes);
        asset.attributes().remove("last_modified");
        tx.saveAsset(asset);
    }

    private void replicateComponent(StorageTx tx, MavenPath mavenPath, NestedAttributesMap componentAttributes) {
        Component component = MavenFacetUtils.findComponent(tx, this.getRepository(), mavenPath);
        if (component != null) {
            component.attributes(componentAttributes);
            tx.saveComponent(component);
        }
    }

    @Transactional
    public boolean doReplicateDelete(String path) {
        try {
            OrientMavenFacet mavenFacet = (OrientMavenFacet)this.facet(OrientMavenFacet.class);
            MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
            return !mavenFacet.delete(mavenPath).isEmpty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

