/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.reader.IndexWriter;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.RecordCompactor;
import org.apache.maven.index.reader.WritableResourceHandler;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.Attributes;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public final class OrientMavenIndexPublisher
extends MavenIndexPublisher {
    private static final String SELECT_HOSTED_ARTIFACTS = "SELECT last_updated AS lastModified, component.group AS groupId, component.name AS artifactId, component.attributes.maven2.baseVersion AS version, component.attributes.maven2.packaging AS packaging, component.attributes.maven2.pom_name AS pom_name, component.attributes.maven2.pom_description AS pom_description, attributes.maven2.classifier AS classifier, name AS path, attributes.content.last_modified AS contentLastModified, size AS contentSize, attributes.checksum.sha1 AS sha1 FROM asset WHERE bucket=:bucket AND attributes.maven2.asset_kind=:asset_kind AND component IS NOT NULL";

    @Override
    protected MavenPathParser getMavenPathParser(Repository repository) {
        return ((OrientMavenFacet)repository.facet(OrientMavenFacet.class)).getMavenPathParser();
    }

    @Override
    protected WritableResourceHandler getResourceHandler(Repository repository) {
        return new Maven2WritableResourceHandler(repository);
    }

    @Override
    protected boolean delete(Repository repository, String path) throws IOException {
        OrientMavenFacet mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        MavenPath mavenPath = this.getMavenPathParser(repository).parsePath(path);
        return !mavenFacet.delete(mavenPath).isEmpty();
    }

    @Override
    protected Iterable<Iterable<Record>> getGroupRecords(List<Repository> repositories, Closer closer) throws IOException {
        UnitOfWork paused = UnitOfWork.pause();
        try {
            ArrayList<Iterable<Record>> records = new ArrayList<Iterable<Record>>();
            for (Repository repository : repositories) {
                UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
                try {
                    try {
                        records.add(this.getRecords(repository, closer));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                finally {
                    UnitOfWork.end();
                }
            }
            ArrayList<Iterable<Record>> arrayList = records;
            return arrayList;
        }
        finally {
            UnitOfWork.resume((UnitOfWork)paused);
        }
    }

    @Override
    public void publishHostedIndex(Repository repository, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Transactional.operation.throwing(IOException.class).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Throwable throwable = null;
            Object var5_6 = null;
            try (Maven2WritableResourceHandler resourceHandler = new Maven2WritableResourceHandler(repository);){
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (IndexWriter indexWriter = new IndexWriter((WritableResourceHandler)resourceHandler, repository.getName(), false);){
                    indexWriter.writeChunk(Iterables.transform(OrientMavenIndexPublisher.decorate(Iterables.filter(this.getHostedRecords(tx, repository), (Predicate)duplicateDetectionStrategy), repository.getName()), arg_0 -> ((RecordCompactor)RECORD_COMPACTOR).apply(arg_0)).iterator());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return null;
        });
    }

    private Iterable<Record> getHostedRecords(StorageTx tx, Repository repository) {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("bucket", AttachedEntityHelper.id((Entity)tx.findBucket(repository)));
        sqlParams.put("asset_kind", Attributes.AssetKind.ARTIFACT.name());
        Iterable documents = tx.browse(SELECT_HOSTED_ARTIFACTS, sqlParams);
        OrientMavenFacet mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        return this.filterAndConvertToRecords(documents, mavenFacet);
    }

    @VisibleForTesting
    Iterable<Record> filterAndConvertToRecords(Iterable<ODocument> documents, OrientMavenFacet mavenFacet) {
        return StreamSupport.stream(documents.spliterator(), false).filter(document -> this.isCorrectComponent(mavenFacet, (ODocument)document)).map(document -> this.toRecord(mavenFacet, (ODocument)document)).collect(Collectors.toList());
    }

    private boolean isCorrectComponent(OrientMavenFacet mavenFacet, ODocument document) {
        Preconditions.checkNotNull((Object)document);
        String path = (String)document.field("path", String.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
        return mavenPath.getCoordinates() != null && !mavenPath.isSubordinate();
    }

    private Record toRecord(OrientMavenFacet mavenFacet, ODocument document) {
        String path = (String)document.field("path", String.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
        Record record = new Record(Record.Type.ARTIFACT_ADD, new HashMap());
        record.put(Record.REC_MODIFIED, (Object)((Long)document.field("lastModified", Long.class)));
        record.put(Record.GROUP_ID, (Object)((String)document.field("groupId", String.class)));
        record.put(Record.ARTIFACT_ID, (Object)((String)document.field("artifactId", String.class)));
        record.put(Record.VERSION, (Object)((String)document.field("version", String.class)));
        record.put(Record.CLASSIFIER, (Object)((String)document.field("classifier", String.class)));
        String packaging = (String)document.field("packaging", String.class);
        if (packaging != null) {
            record.put(Record.PACKAGING, (Object)packaging);
        } else {
            record.put(Record.PACKAGING, (Object)OrientMavenIndexPublisher.pathExtension(mavenPath.getFileName()));
        }
        record.put(Record.NAME, (Object)OrientMavenIndexPublisher.defStr((String)document.field("pom_name", String.class), ""));
        record.put(Record.DESCRIPTION, (Object)OrientMavenIndexPublisher.defStr((String)document.field("pom_description", String.class), ""));
        this.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_SOURCES, mavenPath.locate("jar", "sources"), mavenFacet);
        this.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_JAVADOC, mavenPath.locate("jar", "javadoc"), mavenFacet);
        this.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_SIGNATURE, mavenPath.signature(MavenPath.SignatureType.GPG), mavenFacet);
        record.put(Record.FILE_EXTENSION, (Object)OrientMavenIndexPublisher.pathExtension(mavenPath.getFileName()));
        record.put(Record.FILE_MODIFIED, (Object)((Long)document.field("contentLastModified", Long.class)));
        record.put(Record.FILE_SIZE, (Object)((Long)document.field("contentSize", Long.class)));
        record.put(Record.SHA1, (Object)((String)document.field("sha1", String.class)));
        return record;
    }

    private void checkExistence(Record record, Record.EntryKey<Boolean> key, MavenPath tocheck, OrientMavenFacet mavenFacet) {
        record.put(key, (Object)mavenFacet.exists(tocheck));
    }

    private static String defStr(String s, String defaultValue) {
        if (Strings2.isBlank((String)s)) {
            return defaultValue;
        }
        return s;
    }

    private static class Maven2WritableResource
    implements WritableResourceHandler.WritableResource {
        private final MavenPath mavenPath;
        private final OrientMavenFacet mavenFacet;
        private final String contentType;
        private Path path;

        private Maven2WritableResource(MavenPath mavenPath, OrientMavenFacet mavenFacet, String contenType) {
            this.mavenPath = mavenPath;
            this.mavenFacet = mavenFacet;
            this.contentType = contenType;
            this.path = null;
        }

        public InputStream read() throws IOException {
            Content content = this.mavenFacet.get(this.mavenPath);
            if (content != null) {
                return content.openInputStream();
            }
            return null;
        }

        public OutputStream write() throws IOException {
            this.path = File.createTempFile(this.mavenPath.getFileName(), "tmp").toPath();
            return new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
        }

        public void close() throws IOException {
            if (this.path != null) {
                this.mavenFacet.put(this.mavenPath, (Payload)OrientMavenIndexPublisher.createStreamPayload(this.path, this.contentType));
                Files.delete(this.path);
                this.path = null;
            }
        }
    }

    static class Maven2WritableResourceHandler
    implements WritableResourceHandler {
        private final OrientMavenFacet mavenFacet;

        Maven2WritableResourceHandler(Repository repository) {
            this.mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        }

        public Maven2WritableResource locate(String name) {
            MavenPath mavenPath = this.mavenFacet.getMavenPathParser().parsePath("/.index/" + name);
            return new Maven2WritableResource(mavenPath, this.mavenFacet, OrientMavenIndexPublisher.determineContentType(name));
        }

        public void close() {
        }
    }
}

