/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.hash.HashCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenUploadHandlerSupport;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Maven2MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.MavenPomGenerator;
import org.sonatype.nexus.repository.maven.internal.VersionPolicyValidator;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="maven2")
@Singleton
public class MavenUploadHandler
extends MavenUploadHandlerSupport {
    @Inject
    public MavenUploadHandler(Maven2MavenPathParser parser, @Named(value="maven2") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, VersionPolicyValidator versionPolicyValidator, MavenPomGenerator mavenPomGenerator, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(parser, variableResolverAdapter, contentPermissionChecker, versionPolicyValidator, mavenPomGenerator, uploadDefinitionExtensions);
    }

    @Override
    protected UploadResponse getUploadResponse(Repository repository, ComponentUpload componentUpload, String basePath) throws IOException {
        MavenUploadHandlerSupport.ContentAndAssetPathResponseData responseData;
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        UnitOfWork.begin((Supplier)storageFacet.txSupplier());
        try {
            responseData = this.createAssets(repository, basePath, componentUpload.getAssetUploads());
            this.maybeGeneratePom(repository, componentUpload, basePath, responseData);
            this.updateMetadata(repository, responseData.getCoordinates());
        }
        finally {
            UnitOfWork.end();
        }
        return responseData.uploadResponse();
    }

    private void updateMetadata(Repository repository, MavenPath.Coordinates coordinates) {
        if (coordinates != null) {
            ((MavenHostedFacet)repository.facet(MavenHostedFacet.class)).rebuildMetadata(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion(), false);
        } else {
            this.log.debug("Not updating metadata.xml files since coordinate could not be retrieved from path");
        }
    }

    @Override
    protected Content doPut(ImportFileConfiguration configuration) throws IOException {
        OrientMavenFacet mavenFacet = (OrientMavenFacet)configuration.getRepository().facet(OrientMavenFacet.class);
        MavenPath mavenPath = this.parser.parsePath(configuration.getAssetName());
        File content = configuration.getFile();
        Path contentPath = content.toPath();
        if (configuration.isHardLinkingEnabled()) {
            AttributesMap contentAttributes = new AttributesMap();
            contentAttributes.set("last_modified", (Object)new DateTime(Files.getLastModifiedTime(contentPath, new LinkOption[0]).toMillis()));
            byte[] bytes = Files.readAllBytes(contentPath);
            Map<HashAlgorithm, HashCode> hashes = MavenPath.HashType.ALGORITHMS.stream().collect(Collectors.toMap(a -> a, a -> a.function().hashBytes(bytes)));
            return mavenFacet.put(mavenPath, contentPath, configuration.getAssetName(), contentAttributes, hashes, Files.size(contentPath));
        }
        Throwable throwable = null;
        Object var7_10 = null;
        try (FileInputStream fis = new FileInputStream(content);){
            StreamPayload payload = new StreamPayload(() -> fis, content.length(), Files.probeContentType(contentPath));
            return this.doPut(configuration.getRepository(), mavenPath, (Payload)payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected Content doPut(Repository repository, MavenPath mavenPath, Payload payload) throws IOException {
        OrientMavenFacet mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        Content asset = mavenFacet.put(mavenPath, payload);
        this.putChecksumFiles(mavenFacet, mavenPath, asset);
        return asset;
    }

    @Override
    protected VersionPolicy getVersionPolicy(Repository repository) {
        return ((MavenFacet)repository.facet(MavenFacet.class)).getVersionPolicy();
    }

    @Override
    protected TempBlob createTempBlob(Repository repository, PartPayload payload) {
        return ((StorageFacet)repository.facet(StorageFacet.class)).createTempBlob((Payload)payload, MavenPath.HashType.ALGORITHMS);
    }

    private void putChecksumFiles(OrientMavenFacet facet, MavenPath path, Content content) throws IOException {
        DateTime dateTime = (DateTime)content.getAttributes().require("last_modified", DateTime.class);
        Map<HashAlgorithm, HashCode> hashes = MavenFacetUtils.getHashAlgorithmFromContent(content.getAttributes());
        MavenFacetUtils.addHashes(facet, path, hashes, dateTime);
    }
}

