/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityBatchEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataUtils;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenHostedFacetImpl
extends FacetSupport
implements MavenHostedFacet {
    private static final String MAVEN_ARCHETYPE_PACKAGING = "maven-archetype";
    private static final String SELECT_HOSTED_ARCHETYPES = "SELECT attributes.maven2.groupId AS groupId, attributes.maven2.artifactId AS artifactId, attributes.maven2.version AS version, attributes.maven2.pom_description AS description FROM component WHERE bucket=:bucket AND attributes.maven2.packaging=:packaging";
    private final MetadataRebuilder metadataRebuilder;
    private OrientMavenFacet mavenFacet;
    private MavenPath archetypeCatalogMavenPath;

    @Inject
    public MavenHostedFacetImpl(MetadataRebuilder metadataRebuilder) {
        this.metadataRebuilder = (MetadataRebuilder)Preconditions.checkNotNull((Object)metadataRebuilder);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenFacet = (OrientMavenFacet)this.facet(OrientMavenFacet.class);
        this.archetypeCatalogMavenPath = this.mavenFacet.getMavenPathParser().parsePath("/archetype-catalog.xml");
    }

    @Override
    public void rebuildMetadata(@Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, boolean rebuildChecksums) {
        boolean update = !Strings.isNullOrEmpty((String)groupId) || !Strings.isNullOrEmpty((String)artifactId) || !Strings.isNullOrEmpty((String)baseVersion);
        this.rebuildMetadata(groupId, artifactId, baseVersion, rebuildChecksums, update);
    }

    @Override
    public void rebuildMetadata(@Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, boolean rebuildChecksums, boolean update) {
        this.log.debug("Rebuilding Maven2 hosted repository metadata: repository={}, update={}, group={}, artifact={}, baseVersion={}", new Object[]{this.getRepository().getName(), update, groupId, artifactId, baseVersion});
        this.metadataRebuilder.rebuild(this.getRepository(), update, rebuildChecksums, groupId, artifactId, baseVersion);
    }

    @Override
    public int rebuildArchetypeCatalog() throws IOException {
        this.log.debug("Rebuilding hosted archetype catalog for {}", (Object)this.getRepository().getName());
        return this.doRebuildArchetypeCatalog();
    }

    @Override
    public void deleteMetadata(List<String[]> gavs) {
        this.log.debug("Deleting Maven2 metadata for {} GAVs for repository={}", (Object)gavs.size(), (Object)this.getRepository().getName());
        this.metadataRebuilder.deleteMetadata(this.getRepository(), gavs);
    }

    @Override
    public Set<String> deleteMetadata(String groupId, String artifactId, String baseVersion) {
        this.log.debug("Deleting Maven2 hosted repository metadata: repository={}, group={}, artifact={}, baseVersion={}", new Object[]{this.getRepository().getName(), groupId, artifactId, baseVersion});
        try {
            return OrientMetadataUtils.deleteAndAddRebuildFlag(this.getRepository(), groupId, artifactId, baseVersion);
        }
        catch (IOException e) {
            this.log.error("Failed to delete maven-metadata.xml of {}:{}:{}", new Object[]{groupId, artifactId, baseVersion, e});
            return Collections.emptySet();
        }
    }

    @TransactionalStoreBlob
    protected int doRebuildArchetypeCatalog() throws IOException {
        Path path = Files.createTempFile("hosted-archetype-catalog", "xml", new FileAttribute[0]);
        int count = 0;
        try {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Iterable<Archetype> archetypes = this.getArchetypes(tx);
            ArchetypeCatalog hostedCatalog = new ArchetypeCatalog();
            Iterables.addAll((Collection)hostedCatalog.getArchetypes(), archetypes);
            count = hostedCatalog.getArchetypes().size();
            Throwable throwable = null;
            Object var7_8 = null;
            try (Content content = MavenFacetUtils.createTempContent(path, "application/xml", outputStream -> MavenModels.writeArchetypeCatalog(outputStream, hostedCatalog));){
                MavenFacetUtils.putWithHashes(this.mavenFacet, this.archetypeCatalogMavenPath, content);
                this.log.trace("Rebuilt hosted archetype catalog for {} with {} archetype", (Object)this.getRepository().getName(), (Object)count);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Files.delete(path);
        }
        return count;
    }

    protected Iterable<Archetype> getArchetypes(StorageTx tx) throws IOException {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("bucket", AttachedEntityHelper.id((Entity)tx.findBucket(this.getRepository())));
        sqlParams.put("packaging", MAVEN_ARCHETYPE_PACKAGING);
        return Iterables.transform((Iterable)tx.browse(SELECT_HOSTED_ARCHETYPES, sqlParams), document -> {
            Archetype archetype = new Archetype();
            archetype.setGroupId((String)document.field("groupId", String.class));
            archetype.setArtifactId((String)document.field("artifactId", String.class));
            archetype.setVersion((String)document.field("version", String.class));
            archetype.setDescription((String)document.field("description", String.class));
            return archetype;
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(EntityBatchEvent batchEvent) {
        boolean deleteCatalog = false;
        for (EntityEvent event : batchEvent.getEvents()) {
            if (!(event instanceof ComponentEvent)) continue;
            ComponentEvent componentEvent = (ComponentEvent)event;
            if (!this.getRepository().getName().equals(componentEvent.getRepositoryName()) || !MAVEN_ARCHETYPE_PACKAGING.equals(componentEvent.getComponent().formatAttributes().get("packaging", String.class))) continue;
            deleteCatalog = true;
            break;
        }
        if (deleteCatalog) {
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                try {
                    TransactionalDeleteBlob.operation.throwing(IOException.class).call(() -> MavenFacetUtils.deleteWithHashes(this.mavenFacet, this.archetypeCatalogMavenPath));
                }
                catch (IOException e) {
                    this.log.warn("Could not delete {}", (Object)this.archetypeCatalogMavenPath, (Object)e);
                    UnitOfWork.end();
                }
            }
            finally {
                UnitOfWork.end();
            }
        }
    }
}

