/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.utils.HashedPayload;
import org.sonatype.nexus.repository.maven.internal.utils.MavenIOUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public final class MavenFacetUtils {
    public static final Comparator<Component> COMPONENT_VERSION_COMPARATOR = Comparator.comparing(o -> VersionComparator.version((String)o.version()));

    private MavenFacetUtils() {
    }

    @Nullable
    public static Component findComponent(StorageTx tx, Repository repository, MavenPath mavenPath) {
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        Iterable components = tx.findComponents(Query.builder().where("group").eq((Object)coordinates.getGroupId()).and("name").eq((Object)coordinates.getArtifactId()).and("version").eq((Object)coordinates.getVersion()).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Bucket bucket, MavenPath mavenPath) {
        return tx.findAssetWithProperty("name", (Object)mavenPath.getPath(), bucket);
    }

    public static boolean isRelease(Component component) {
        return !MavenFacetUtils.isSnapshot(component);
    }

    public static boolean isSnapshot(Component component) {
        String baseVersion = (String)component.attributes().child("maven2").get("baseVersion");
        return baseVersion != null && baseVersion.endsWith("SNAPSHOT");
    }

    public static Content createTempContent(Path path, String contentType, MavenIOUtils.Writer writer) throws IOException {
        HashedPayload hashedPayload = MavenIOUtils.createStreamPayload(path, contentType, writer);
        Content content = new Content(hashedPayload.getPayload());
        content.getAttributes().set("last_modified", (Object)DateTime.now());
        content.getAttributes().set("hashCodesMap", hashedPayload.getHashCodes());
        MavenFacetUtils.mayAddETag(content.getAttributes(), hashedPayload.getHashCodes());
        return content;
    }

    public static void mayAddETag(AttributesMap attributesMap, Map<HashAlgorithm, HashCode> hashCodes) {
        if (attributesMap.contains("etag")) {
            return;
        }
        HashCode sha1HashCode = hashCodes.get(HashAlgorithm.SHA1);
        if (sha1HashCode != null) {
            attributesMap.set("etag", (Object)("{SHA1{" + sha1HashCode + "}}"));
        }
    }

    public static Map<HashAlgorithm, HashCode> getHashAlgorithmFromContent(AttributesMap attributesMap) {
        return (Map)attributesMap.require("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
    }

    public static void putWithHashes(OrientMavenFacet mavenFacet, MavenPath mavenPath, Content content) throws IOException {
        Map<HashAlgorithm, HashCode> hashCodes = MavenFacetUtils.getHashAlgorithmFromContent(content.getAttributes());
        DateTime now = (DateTime)content.getAttributes().require("last_modified", DateTime.class);
        mavenFacet.put(mavenPath, (Payload)content);
        MavenFacetUtils.addHashes(mavenFacet, mavenPath, hashCodes, now);
    }

    public static void addHashes(OrientMavenFacet mavenFacet, MavenPath mavenPath, Map<HashAlgorithm, HashCode> hashCodes, DateTime now) throws IOException {
        for (Map.Entry<MavenPath.HashType, Payload> entry : MavenIOUtils.hashesToPayloads(hashCodes).entrySet()) {
            Content hashedContent = new Content(entry.getValue());
            hashedContent.getAttributes().set("last_modified", (Object)now);
            mavenFacet.put(mavenPath.hash(entry.getKey()), (Payload)hashedContent);
        }
    }

    public static Content putWithHashes(OrientMavenFacet mavenFacet, MavenPath mavenPath, TempBlob tempBlob, String contentType, AttributesMap attributesMap) throws IOException {
        DateTime now = DateTime.now();
        Content result = mavenFacet.put(mavenPath, tempBlob, contentType, attributesMap);
        result.getAttributes().set("last_modified", (Object)now);
        MavenFacetUtils.addHashes(mavenFacet, mavenPath, tempBlob.getHashes(), now);
        return result;
    }

    public static Set<String> deleteWithHashes(OrientMavenFacet mavenFacet, MavenPath mavenPath) throws IOException {
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>(MavenPath.HashType.values().length + 1);
        paths.add(mavenPath.main());
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            paths.add(mavenPath.main().hash(hashType));
            ++n2;
        }
        return mavenFacet.delete(paths.toArray(new MavenPath[paths.size()]));
    }

    public static Set<String> deleteWithHashes(OrientMavenFacet mavenFacet, List<MavenPath> mavenPaths) throws IOException {
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>();
        for (MavenPath path : mavenPaths) {
            paths.add(path.main());
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                paths.add(path.main().hash(hashType));
                ++n2;
            }
        }
        return mavenFacet.delete(paths.toArray(new MavenPath[paths.size()]));
    }

    public static Set<String> getPathWithHashes(MavenPath mavenPath) {
        HashSet<String> paths = new HashSet<String>();
        paths.add(mavenPath.main().getPath());
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            paths.add(mavenPath.main().hash(hashType).getPath());
            ++n2;
        }
        return paths;
    }
}

