/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Attributes;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.orient.MavenWritePolicySelector;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMetadataUtils;
import org.sonatype.nexus.repository.maven.internal.validation.MavenMetadataContentValidator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenFacetImpl
extends FacetSupport
implements OrientMavenFacet {
    private static final ThreadLocal<Boolean> rebuilding = new ThreadLocal();
    private static final String ATTR_MAVEN_BASE_VERSION = "attributes.maven2.baseVersion";
    private final Map<String, MavenPathParser> mavenPathParsers;
    @VisibleForTesting
    static final String CONFIG_KEY = "maven";
    private Config config;
    private MavenPathParser mavenPathParser;
    private StorageFacet storageFacet;
    private final MavenMetadataContentValidator metadataValidator;
    private final boolean mavenMetadataValidationEnabled;
    private final OrientMetadataRebuilder metadataRebuilder;

    @Inject
    public MavenFacetImpl(Map<String, MavenPathParser> mavenPathParsers, MavenMetadataContentValidator metadataValidator, @Named(value="${nexus.maven.metadata.validation.enabled:-true}") boolean mavenMetadataValidationEnabled, OrientMetadataRebuilder metadataRebuilder) {
        this.mavenPathParsers = (Map)Preconditions.checkNotNull(mavenPathParsers);
        this.metadataValidator = (MavenMetadataContentValidator)((Object)Preconditions.checkNotNull((Object)((Object)metadataValidator)));
        this.mavenMetadataValidationEnabled = mavenMetadataValidationEnabled;
        this.metadataRebuilder = (OrientMetadataRebuilder)Preconditions.checkNotNull((Object)metadataRebuilder);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)this.mavenPathParsers.get(this.getRepository().getFormat().getValue()));
        this.storageFacet = (StorageFacet)this.getRepository().facet(StorageFacet.class);
        this.storageFacet.registerWritePolicySelector((WritePolicySelector)new MavenWritePolicySelector());
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    @Override
    @Nonnull
    public MavenPathParser getMavenPathParser() {
        return this.mavenPathParser;
    }

    @Override
    @Nonnull
    public VersionPolicy getVersionPolicy() {
        return this.config.versionPolicy;
    }

    @Override
    public LayoutPolicy layoutPolicy() {
        return this.config.layoutPolicy;
    }

    @Override
    @Nullable
    public Content get(MavenPath path) throws IOException {
        this.log.debug("GET {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
        return this.doGet(path);
    }

    @Nullable
    @TransactionalStoreBlob
    protected Content doGet(MavenPath path) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = MavenFacetUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        if (this.needsRebuild(path, asset)) {
            block5: {
                OrientMetadataUtils.removeRebuildFlag(asset);
                tx.saveAsset(asset);
                this.rebuildMetadata(blob);
                asset = MavenFacetUtils.findAsset(tx, bucket, path);
                if (asset != null) break block5;
                return null;
            }
            try {
                blob = tx.requireBlob(asset.requireBlobRef());
            }
            catch (OModificationOperationProhibitedException e) {
                this.log.debug("Cannot rebuild metadata when NXRM is read-only {} : {}", new Object[]{this.getRepository().getName(), path.getPath(), e});
            }
        }
        return this.toContent(asset, blob);
    }

    private void rebuildMetadata(Blob metadataBlob) throws IOException {
        Metadata metadata;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = metadataBlob.getInputStream();){
            metadata = MavenModels.readMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        rebuilding.set(Boolean.TRUE);
        try {
            this.metadataRebuilder.refreshInTransaction(this.getRepository(), false, false, metadata.getGroupId(), metadata.getArtifactId(), metadata.getVersion());
        }
        finally {
            rebuilding.remove();
        }
    }

    private boolean needsRebuild(MavenPath path, Asset asset) {
        return !Boolean.TRUE.equals(rebuilding.get()) && path.getFileName().equals("maven-metadata.xml") && !(this.getRepository().getType() instanceof ProxyType) && OrientMetadataUtils.requiresRebuild(asset);
    }

    private Content toContent(Asset asset, Blob blob) {
        String contentType = asset.contentType();
        Content content = new Content((Payload)new BlobPayload(blob, contentType));
        Content.extractFromAsset((Asset)asset, MavenPath.HashType.ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    public Content put(MavenPath path, Payload payload) throws IOException {
        this.log.debug("PUT {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.storageFacet.createTempBlob(payload, MavenPath.HashType.ALGORITHMS);){
            if (path.getFileName().equals("maven-metadata.xml") && this.mavenMetadataValidationEnabled) {
                this.log.debug("Validating maven-metadata.xml before storing");
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (InputStream in = tempBlob.get();){
                        this.metadataValidator.validate(path.getPath(), in);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (InvalidContentException e) {
                    this.log.warn(e.toString());
                    Content content = Optional.ofNullable(this.get(path)).orElseThrow(() -> e);
                    if (tempBlob != null) {
                        tempBlob.close();
                    }
                    return content;
                }
            }
            return this.doPut(path, payload, tempBlob);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public Content put(MavenPath path, Path sourceFile, String contentType, AttributesMap contentAttributes, Map<HashAlgorithm, HashCode> hashes, long size) throws IOException {
        this.log.debug("PUT {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
        return this.doPut(path, sourceFile, contentType, contentAttributes, hashes, size);
    }

    @Override
    public Content put(MavenPath path, TempBlob blob, String contentType, AttributesMap contentAttributes) throws IOException {
        return this.doPut(path, blob, contentType, contentAttributes);
    }

    @TransactionalStoreBlob
    protected Content doPut(MavenPath path, Payload payload, TempBlob tempBlob) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = tx.createBlob(path.getPath(), tempBlob, null, payload.getContentType(), false);
        AttributesMap contentAttributes = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
        }
        return this.doPutAssetBlob(path, contentAttributes, tx, assetBlob);
    }

    @TransactionalStoreBlob
    protected Content doPut(MavenPath path, Path sourceFile, String contentType, AttributesMap contentAttributes, Map<HashAlgorithm, HashCode> hashes, long size) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = tx.createBlob(path.getPath(), sourceFile, hashes, this.extractBlobHeaders(contentAttributes), contentType, size);
        return this.doPutAssetBlob(path, contentAttributes, tx, assetBlob);
    }

    @TransactionalStoreBlob
    protected Content doPut(MavenPath path, TempBlob blob, String contentType, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = tx.createBlob(path.getPath(), blob, this.extractBlobHeaders(contentAttributes), contentType, true);
        return this.doPutAssetBlob(path, contentAttributes, tx, assetBlob);
    }

    private Content doPutAssetBlob(MavenPath path, AttributesMap contentAttributes, StorageTx tx, AssetBlob assetBlob) throws IOException {
        if (path.getCoordinates() != null) {
            return this.toContent(this.putArtifact(tx, path, assetBlob, contentAttributes), assetBlob.getBlob());
        }
        return this.toContent(this.putFile(tx, path, assetBlob, contentAttributes), assetBlob.getBlob());
    }

    private Asset putArtifact(StorageTx tx, MavenPath path, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        MavenPath.Coordinates coordinates = (MavenPath.Coordinates)Preconditions.checkNotNull((Object)path.getCoordinates());
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = MavenFacetUtils.findComponent(tx, this.getRepository(), path);
        boolean updatePomModel = false;
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).group(coordinates.getGroupId()).name(coordinates.getArtifactId())).version(coordinates.getVersion());
            NestedAttributesMap componentAttributes = component.formatAttributes();
            componentAttributes.set("groupId", (Object)coordinates.getGroupId());
            componentAttributes.set("artifactId", (Object)coordinates.getArtifactId());
            componentAttributes.set("version", (Object)coordinates.getVersion());
            componentAttributes.set("baseVersion", (Object)coordinates.getBaseVersion());
            if (path.isPom()) {
                this.fillInFromModel(path, assetBlob, component.formatAttributes());
            }
            tx.saveComponent(component);
        } else if (path.isPom()) {
            updatePomModel = true;
        }
        Asset asset = MavenFacetUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path.getPath());
            NestedAttributesMap assetAttributes = asset.formatAttributes();
            assetAttributes.set("groupId", (Object)coordinates.getGroupId());
            assetAttributes.set("artifactId", (Object)coordinates.getArtifactId());
            assetAttributes.set("version", (Object)coordinates.getVersion());
            assetAttributes.set("baseVersion", (Object)coordinates.getBaseVersion());
            assetAttributes.set("classifier", (Object)coordinates.getClassifier());
            assetAttributes.set("extension", (Object)coordinates.getExtension());
            assetAttributes.set("asset_kind", (Object)(path.isSubordinate() ? Attributes.AssetKind.ARTIFACT_SUBORDINATE.name() : Attributes.AssetKind.ARTIFACT.name()));
        }
        this.putAssetPayload(tx, asset, assetBlob, contentAttributes);
        tx.saveAsset(asset);
        if (updatePomModel && !assetBlob.isDuplicate()) {
            this.fillInFromModel(path, assetBlob, component.formatAttributes());
            tx.saveComponent(component);
        }
        return asset;
    }

    private void fillInFromModel(MavenPath mavenPath, AssetBlob assetBlob, NestedAttributesMap componentAttributes) throws IOException {
        Model model = MavenModels.readModel(assetBlob.getBlob().getInputStream());
        if (model == null) {
            this.log.warn("Could not parse POM: {} @ {}", (Object)this.getRepository().getName(), (Object)mavenPath.getPath());
            return;
        }
        String packaging = model.getPackaging();
        componentAttributes.set("packaging", (Object)(packaging == null ? "jar" : packaging));
        componentAttributes.set("pom_name", (Object)model.getName());
        componentAttributes.set("pom_description", (Object)model.getDescription());
    }

    @Override
    @TransactionalStoreMetadata
    public Asset put(MavenPath path, AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (path.getCoordinates() != null) {
            return this.putArtifact(tx, path, assetBlob, contentAttributes);
        }
        return this.putFile(tx, path, assetBlob, contentAttributes);
    }

    @Override
    @Transactional
    public boolean exists(MavenPath path) {
        this.log.debug("EXISTS {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = MavenFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), path);
        return asset != null;
    }

    private Asset putFile(StorageTx tx, MavenPath path, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = MavenFacetUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path.getPath());
            asset.formatAttributes().set("asset_kind", (Object)this.fileAssetKindFor(path));
        }
        this.putAssetPayload(tx, asset, assetBlob, contentAttributes);
        tx.saveAsset(asset);
        return asset;
    }

    private void putAssetPayload(StorageTx tx, Asset asset, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) {
        AttributesMap contentAttributesWithLastModified = Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes);
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributesWithLastModified);
        tx.attachBlob(asset, assetBlob);
        if (contentAttributesWithLastModified.contains("blob_created")) {
            asset.blobCreated((DateTime)contentAttributesWithLastModified.get("blob_created", DateTime.class));
        }
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> delete(MavenPath ... paths) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        HashSet deletedPaths = Sets.newHashSet();
        MavenPath[] mavenPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath path = mavenPathArray[n2];
            this.log.trace("DELETE {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
            if (this.deleteFileOrArtifact(tx, path)) {
                deletedPaths.add(path.getPath());
            }
            ++n2;
        }
        return deletedPaths;
    }

    @Override
    public Set<String> deleteAssetOnly(MavenPath ... paths) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        HashSet deletedPaths = Sets.newHashSet();
        MavenPath[] mavenPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath path = mavenPathArray[n2];
            this.log.trace("DELETE ASSET ONLY {} : {}", (Object)this.getRepository().getName(), (Object)path.getPath());
            if (this.deleteFile(path, tx, false)) {
                deletedPaths.add(path.getPath());
            }
            ++n2;
        }
        return deletedPaths;
    }

    private boolean deleteFileOrArtifact(StorageTx tx, MavenPath mavenPath) {
        if (mavenPath.getCoordinates() != null) {
            return this.deleteArtifact(mavenPath, tx);
        }
        return this.deleteFile(mavenPath, tx);
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> maybeDeleteOrFlagToRebuildMetadata(Bucket bucket, String groupId, String artifactId, String baseVersion) throws IOException {
        Preconditions.checkNotNull((Object)groupId);
        MavenPath path = MetadataUtils.metadataPath(groupId, artifactId, baseVersion);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset metadata = MavenFacetUtils.findAsset(tx, bucket, path);
        if (metadata != null) {
            long count;
            Query.Builder query = Query.builder();
            query.where("group").eq((Object)groupId);
            if (StringUtils.isNotEmpty((CharSequence)artifactId)) {
                query.and("name").eq((Object)artifactId);
            }
            if (StringUtils.isNotEmpty((CharSequence)baseVersion)) {
                query.and(ATTR_MAVEN_BASE_VERSION).eq((Object)baseVersion);
            }
            if ((count = tx.countComponents(query.build(), Collections.singletonList(this.getRepository()))) == 0L) {
                return MavenFacetUtils.deleteWithHashes((OrientMavenFacet)this, path);
            }
            OrientMetadataUtils.addRebuildFlag(metadata);
            tx.saveAsset(metadata);
            return Collections.emptySet();
        }
        return Collections.emptySet();
    }

    private boolean deleteArtifact(MavenPath path, StorageTx tx) {
        Component component = MavenFacetUtils.findComponent(tx, this.getRepository(), path);
        if (component == null) {
            return false;
        }
        Asset asset = MavenFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return false;
        }
        tx.deleteAsset(asset);
        if (!tx.browseAssets(component).iterator().hasNext()) {
            tx.deleteComponent(component);
        }
        return true;
    }

    private boolean deleteFile(MavenPath path, StorageTx tx) {
        return this.deleteFile(path, tx, true);
    }

    private boolean deleteFile(MavenPath path, StorageTx tx, boolean deleteBlob) {
        Asset asset = MavenFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return false;
        }
        tx.deleteAsset(asset, deleteBlob);
        return true;
    }

    private String fileAssetKindFor(MavenPath path) {
        if (this.getMavenPathParser().isRepositoryMetadata(path)) {
            return Attributes.AssetKind.REPOSITORY_METADATA.name();
        }
        if (this.getMavenPathParser().isRepositoryIndex(path)) {
            return Attributes.AssetKind.REPOSITORY_INDEX.name();
        }
        return Attributes.AssetKind.OTHER.name();
    }

    private Map<String, String> extractBlobHeaders(AttributesMap contentAttributes) {
        Preconditions.checkNotNull((Object)contentAttributes);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (contentAttributes.contains("created_by")) {
            headers.put("BlobStore.created-by", (String)contentAttributes.get("created_by", String.class));
        }
        if (contentAttributes.contains("created_by_ip")) {
            headers.put("BlobStore.created-by-ip", (String)contentAttributes.get("created_by_ip", String.class));
        }
        return headers.isEmpty() ? null : headers;
    }

    @VisibleForTesting
    static class Config {
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public VersionPolicy versionPolicy;
        @NotNull(groups={HostedType.ValidationGroup.class, ProxyType.ValidationGroup.class})
        public LayoutPolicy layoutPolicy;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "versionPolicy=" + (Object)((Object)this.versionPolicy) + ", layoutPolicy=" + (Object)((Object)this.layoutPolicy) + '}';
        }
    }
}

