/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;

@Named(value="maven2")
@Singleton
public class MavenComponentDirector
implements ComponentDirector {
    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        VersionPolicy versionPolicy = ((MavenFacet)destination.facet(MavenFacet.class)).getVersionPolicy();
        if (VersionPolicy.MIXED.equals((Object)versionPolicy)) {
            return true;
        }
        if (MavenFacetUtils.isSnapshot(component)) {
            return VersionPolicy.SNAPSHOT.equals((Object)versionPolicy);
        }
        return VersionPolicy.RELEASE.equals((Object)versionPolicy);
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        destination.optionalFacet(MavenHostedFacet.class).ifPresent(facet -> components.stream().map(component -> Pair.of((Object)((String)component.get("group")), (Object)((String)component.get("name")))).distinct().forEach(pair -> facet.rebuildMetadata((String)pair.getLeft(), (String)pair.getRight(), null, false)));
    }
}

