/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.DeconflictStepSupport;
import org.sonatype.nexus.repository.storage.Component;

@Named
@Singleton
public class DeconflictComponentMavenAttributes
extends DeconflictStepSupport<Component> {
    private static final String MAVEN_ATTRIBUTES = "attributes.maven2";
    private static final String PACKAGING_ATTRIBUTE = "attributes.maven2.packaging";

    public ConflictState deconflict(ODocument storedRecord, ODocument changeRecord) {
        Object storedMaven = storedRecord.rawField(MAVEN_ATTRIBUTES);
        Object changeMaven = changeRecord.rawField(MAVEN_ATTRIBUTES);
        if (storedMaven != null && changeMaven != null) {
            return DeconflictComponentMavenAttributes.pickNonNull((ODocument)storedRecord, (ODocument)changeRecord, (String)PACKAGING_ATTRIBUTE);
        }
        if (changeMaven != null) {
            storedRecord.field(MAVEN_ATTRIBUTES, changeMaven);
            return ConflictState.ALLOW;
        }
        if (storedMaven != null) {
            changeRecord.field(MAVEN_ATTRIBUTES, storedMaven);
            return ConflictState.MERGE;
        }
        return ConflictState.IGNORE;
    }
}

