/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.view.Content;

public class ArchetypeCatalogMerger
extends ComponentSupport {
    public void merge(OutputStream outputStream, MavenPath mavenPath, Map<Repository, Content> contents) {
        this.log.debug("Merge archetype catalog for {}", (Object)mavenPath.getPath());
        ArchetypeCatalog mergedCatalog = new ArchetypeCatalog();
        UniqueFilter uniqueFilter = new UniqueFilter();
        try {
            for (Map.Entry<Repository, Content> entry : contents.entrySet()) {
                String origin = String.valueOf(entry.getKey().getName()) + " @ " + mavenPath.getPath();
                ArchetypeCatalog catalog = MavenModels.readArchetypeCatalog(entry.getValue().openInputStream());
                if (catalog == null) {
                    this.log.debug("Corrupted archetype catalog: {}", (Object)origin);
                    continue;
                }
                for (Archetype archetype : catalog.getArchetypes()) {
                    if (!uniqueFilter.apply(archetype)) continue;
                    archetype.setRepository(null);
                    mergedCatalog.addArchetype(archetype);
                }
            }
            this.sortArchetypes(mergedCatalog);
            MavenModels.writeArchetypeCatalog(outputStream, mergedCatalog);
        }
        catch (IOException e) {
            this.log.error("Unable to merge {}", (Object)mavenPath, (Object)e);
        }
    }

    private void sortArchetypes(ArchetypeCatalog mergedCatalog) {
        Collections.sort(mergedCatalog.getArchetypes(), (o1, o2) -> {
            int gc = o1.getGroupId().compareTo(o2.getGroupId());
            if (gc != 0) {
                return gc;
            }
            int ac = o1.getArtifactId().compareTo(o2.getArtifactId());
            if (ac != 0) {
                return ac;
            }
            return VersionComparator.version((String)o1.getVersion()).compareTo((Object)VersionComparator.version((String)o2.getVersion()));
        });
    }

    private static class UniqueFilter
    implements Predicate<Archetype> {
        private Map<String, Map<String, Set<String>>> gav = new HashMap<String, Map<String, Set<String>>>();

        private UniqueFilter() {
        }

        public boolean apply(Archetype input) {
            Set<String> vSet;
            String g = input.getGroupId();
            String a = input.getArtifactId();
            String v = input.getVersion();
            Map<String, Set<String>> aMap = this.gav.get(g);
            if (aMap == null) {
                aMap = new HashMap<String, Set<String>>();
                this.gav.put(g, aMap);
            }
            if ((vSet = aMap.get(a)) == null) {
                vSet = new HashSet<String>();
                aMap.put(a, vSet);
            }
            return vSet.add(v);
        }
    }
}

