/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.datastore;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenMetadataRebuildFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.datastore.MavenFacetUtils;

@Named(value="maven2")
@Singleton
public class MavenContentDirector
implements ContentDirector {
    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        VersionPolicy versionPolicy = ((MavenFacet)destination.facet(MavenFacet.class)).getVersionPolicy();
        if (VersionPolicy.MIXED.equals((Object)versionPolicy)) {
            return true;
        }
        if (MavenFacetUtils.isSnapshot((Component)component)) {
            return VersionPolicy.SNAPSHOT.equals((Object)versionPolicy);
        }
        return VersionPolicy.RELEASE.equals((Object)versionPolicy);
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        MavenMetadataRebuildFacet facet = (MavenMetadataRebuildFacet)destination.facet(MavenMetadataRebuildFacet.class);
        components.stream().map(component -> Pair.of((Object)((String)component.get("group")), (Object)((String)component.get("name")))).distinct().forEach(pair -> facet.rebuildMetadata((String)pair.getLeft(), (String)pair.getRight(), null, false));
    }

    public FluentComponent copyComponent(Component source, Repository destination) {
        return ((MavenContentFacet)destination.facet(MavenContentFacet.class)).copy(source);
    }
}

